/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.x509;

import com.android.apksig.internal.asn1.Asn1Class;
import com.android.apksig.internal.asn1.Asn1Field;
import com.android.apksig.internal.asn1.Asn1OpaqueObject;
import com.android.apksig.internal.asn1.Asn1Type;
import com.android.apksig.internal.pkcs7.AlgorithmIdentifier;
import com.android.apksig.internal.pkcs7.IssuerAndSerialNumber;
import com.android.apksig.internal.pkcs7.SignerIdentifier;
import com.android.apksig.internal.util.ByteBufferUtils;
import com.android.apksig.internal.util.GuaranteedEncodedFormX509Certificate;
import com.android.apksig.internal.util.X509CertificateUtils;
import com.android.apksig.internal.x509.TBSCertificate;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;

@Asn1Class(type=Asn1Type.SEQUENCE)
public class Certificate {
    @Asn1Field(index=0, type=Asn1Type.SEQUENCE)
    public TBSCertificate certificate;
    @Asn1Field(index=1, type=Asn1Type.SEQUENCE)
    public AlgorithmIdentifier signatureAlgorithm;
    @Asn1Field(index=2, type=Asn1Type.BIT_STRING)
    public ByteBuffer signature;

    public static X509Certificate findCertificate(Collection<X509Certificate> certs, SignerIdentifier id) {
        for (X509Certificate cert : certs) {
            if (!Certificate.isMatchingCerticicate(cert, id)) continue;
            return cert;
        }
        return null;
    }

    private static boolean isMatchingCerticicate(X509Certificate cert, SignerIdentifier id) {
        if (id.issuerAndSerialNumber == null) {
            return false;
        }
        IssuerAndSerialNumber issuerAndSerialNumber = id.issuerAndSerialNumber;
        byte[] encodedIssuer = ByteBufferUtils.toByteArray(issuerAndSerialNumber.issuer.getEncoded());
        X500Principal idIssuer = new X500Principal(encodedIssuer);
        BigInteger idSerialNumber = issuerAndSerialNumber.certificateSerialNumber;
        return idSerialNumber.equals(cert.getSerialNumber()) && idIssuer.equals(cert.getIssuerX500Principal());
    }

    public static List<X509Certificate> parseCertificates(List<Asn1OpaqueObject> encodedCertificates) throws CertificateException {
        if (encodedCertificates.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(encodedCertificates.size());
        for (int i4 = 0; i4 < encodedCertificates.size(); ++i4) {
            X509Certificate certificate;
            Asn1OpaqueObject encodedCertificate = encodedCertificates.get(i4);
            byte[] encodedForm = ByteBufferUtils.toByteArray(encodedCertificate.getEncoded());
            try {
                certificate = X509CertificateUtils.generateCertificate(encodedForm);
            }
            catch (CertificateException e5) {
                throw new CertificateException("Failed to parse certificate #" + (i4 + 1), e5);
            }
            certificate = new GuaranteedEncodedFormX509Certificate(certificate, encodedForm);
            result.add(certificate);
        }
        return result;
    }
}

