/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.google.common.collect.ImmutableMap;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Map;

public class BitmapDecoder {
    public static final String BITMAP_FQCN = "android.graphics.Bitmap";
    public static final String BITMAP_DRAWABLE_FQCN = "android.graphics.drawable.BitmapDrawable";
    protected static final Map<String, BitmapExtractor> SUPPORTED_FORMATS = ImmutableMap.of("\"ARGB_8888\"", new ARGB8888_BitmapExtractor(), "\"RGB_565\"", new RGB565_BitmapExtractor(), "\"ALPHA_8\"", new ALPHA8_BitmapExtractor());
    private static final int MAX_DIMENSION = 1024;

    public static BufferedImage getBitmap(BitmapDataProvider dataProvider) throws Exception {
        String config = dataProvider.getBitmapConfigName();
        if (config == null) {
            throw new RuntimeException("Unable to determine bitmap configuration");
        }
        BitmapExtractor bitmapExtractor = SUPPORTED_FORMATS.get(config);
        if (bitmapExtractor == null) {
            throw new RuntimeException("Unsupported bitmap configuration: " + config);
        }
        Dimension size = dataProvider.getDimension();
        if (size == null) {
            throw new RuntimeException("Unable to determine image dimensions.");
        }
        if (size.width > 1024 || size.height > 1024) {
            boolean couldDownsize = dataProvider.downsizeBitmap(size);
            if (!couldDownsize) {
                throw new RuntimeException("Unable to create scaled bitmap");
            }
            size = dataProvider.getDimension();
            if (size == null) {
                throw new RuntimeException("Unable to obtained scaled bitmap's dimensions");
            }
        }
        return bitmapExtractor.getImage(size.width, size.height, dataProvider.getPixelBytes(size));
    }

    private static class ALPHA8_BitmapExtractor
    implements BitmapExtractor {
        private ALPHA8_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            boolean bytesPerPixel = true;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y4 = 0; y4 < height; ++y4) {
                int stride = y4 * width;
                for (int x4 = 0; x4 < width; ++x4) {
                    int index = stride + x4;
                    byte value = rgb[index];
                    int rgba = value << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                    bufferedImage.setRGB(x4, y4, rgba);
                }
            }
            return bufferedImage;
        }
    }

    private static class RGB565_BitmapExtractor
    implements BitmapExtractor {
        private RGB565_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgb) {
            int bytesPerPixel = 2;
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y4 = 0; y4 < height; ++y4) {
                int stride = y4 * width;
                for (int x4 = 0; x4 < width; ++x4) {
                    int index = (stride + x4) * bytesPerPixel;
                    int value = rgb[index] & 0xFF | rgb[index + 1] << 8 & 0xFF00;
                    int r4 = (value >>> 11 & 0x1F) * 255 / 31;
                    int g4 = (value >>> 5 & 0x3F) * 255 / 63;
                    int b5 = (value & 0x1F) * 255 / 31;
                    int a5 = 255;
                    int rgba = a5 << 24 | r4 << 16 | g4 << 8 | b5;
                    bufferedImage.setRGB(x4, y4, rgba);
                }
            }
            return bufferedImage;
        }
    }

    private static class ARGB8888_BitmapExtractor
    implements BitmapExtractor {
        private ARGB8888_BitmapExtractor() {
        }

        @Override
        public BufferedImage getImage(int width, int height, byte[] rgba) {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            for (int y4 = 0; y4 < height; ++y4) {
                int stride = y4 * width;
                for (int x4 = 0; x4 < width; ++x4) {
                    int i4 = (stride + x4) * 4;
                    long rgb = 0L;
                    rgb |= ((long)rgba[i4] & 0xFFL) << 16;
                    rgb |= ((long)rgba[i4 + 1] & 0xFFL) << 8;
                    rgb |= (long)rgba[i4 + 2] & 0xFFL;
                    bufferedImage.setRGB(x4, y4, (int)((rgb |= ((long)rgba[i4 + 3] & 0xFFL) << 24) & 0xFFFFFFFFL));
                }
            }
            return bufferedImage;
        }
    }

    private static interface BitmapExtractor {
        public BufferedImage getImage(int var1, int var2, byte[] var3);
    }

    public static interface BitmapDataProvider {
        public String getBitmapConfigName() throws Exception;

        public Dimension getDimension() throws Exception;

        public boolean downsizeBitmap(Dimension var1) throws Exception;

        public byte[] getPixelBytes(Dimension var1) throws Exception;
    }
}

