/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.JdwpHandshake;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.DdmCommandPacket;
import com.android.ddmlib.internal.jdwp.JdwpClientManager;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerFactory;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerId;
import com.android.ddmlib.internal.jdwp.JdwpConnectionReader;
import com.android.ddmlib.internal.jdwp.JdwpLoggingUtils;
import com.android.ddmlib.internal.jdwp.JdwpSocketHandler;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;

public class JdwpProxyClient
implements JdwpSocketHandler {
    private SocketChannel mClientImplSocket;
    private String mDeviceId = null;
    private int mPid = 0;
    private JdwpClientManager mConnection;
    private boolean mHandshakeComplete = false;
    private JdwpConnectionReader mReader;
    private final JdwpClientManagerFactory mFactory;

    JdwpProxyClient(SocketChannel socket, JdwpClientManagerFactory factory) {
        this.mClientImplSocket = socket;
        this.mFactory = factory;
        this.mReader = new JdwpConnectionReader(this.mClientImplSocket, 1024);
    }

    public boolean isConnected() {
        return this.mClientImplSocket != null;
    }

    @Override
    public void shutdown() throws IOException {
        if (this.mClientImplSocket != null) {
            this.mClientImplSocket.close();
            this.mClientImplSocket = null;
        }
        if (this.mConnection != null) {
            this.mConnection.removeListener(this);
            this.mConnection = null;
        }
    }

    @Override
    public void read() throws IOException, TimeoutException {
        if (this.mClientImplSocket == null) {
            return;
        }
        int length = this.mReader.read();
        if (length == -1) {
            this.shutdown();
            throw new EOFException("Client Disconnected");
        }
        if (this.mDeviceId == null && this.mReader.isHostTransport()) {
            DdmCommandPacket packet = this.mReader.parseCommandPacket();
            this.mDeviceId = packet.getCommand().substring("host:transport:".length());
            this.write("OKAY");
            this.mReader.consumeData(packet.getTotalSize());
        } else if (this.mPid == 0 && this.mReader.isJdwpPid()) {
            DdmCommandPacket packet = this.mReader.parseCommandPacket();
            this.mPid = Integer.parseInt(packet.getCommand().substring("jdwp:".length()));
            JdwpClientManagerId key = new JdwpClientManagerId(this.mDeviceId, this.mPid);
            try {
                this.mConnection = this.mFactory.createConnection(key);
                this.mConnection.addListener(this);
                this.write("OKAY");
            }
            catch (Exception ex) {
                this.writeFailHelper(ex.getMessage());
                this.shutdown();
            }
            this.mReader.consumeData(packet.getTotalSize());
        } else if (this.mReader.isDisconnect()) {
            DdmCommandPacket packet = this.mReader.parseCommandPacket();
            try {
                String[] params = packet.getCommand().split(":");
                JdwpClientManager clientManager = this.mFactory.getConnection(params[1], Integer.parseInt(params[2]));
                if (clientManager == null) {
                    this.writeFailHelper("Unable to find client matching: " + params[1] + " / " + params[2]);
                } else {
                    this.write("OKAY");
                    clientManager.shutdown();
                }
            }
            catch (Exception ex) {
                this.writeFailHelper(ex.getMessage());
            }
            this.mReader.consumeData(packet.getTotalSize());
        } else if (this.mReader.isHandshake()) {
            ByteBuffer handshake = ByteBuffer.allocate(JdwpHandshake.HANDSHAKE_LEN);
            JdwpHandshake.putHandshake(handshake);
            this.write(handshake.array(), handshake.position());
            this.setHandshakeComplete();
            this.mReader.consumeData(JdwpHandshake.HANDSHAKE_LEN);
        } else if (!this.isHandshakeComplete()) {
            Log.e("DDMLIB", "An unexpected packet was received before the handshake.");
            this.mReader.consumePacket();
        } else if (this.mConnection != null) {
            JdwpPacket packet;
            while ((packet = this.mReader.readPacket()) != null) {
                this.mConnection.write(this, packet);
                packet.consume();
            }
        }
    }

    private void writeFailHelper(String message2) throws IOException, TimeoutException {
        this.write("FAIL");
        byte[] reason = AdbHelper.formAdbRequest(message2);
        this.write(reason, reason.length);
    }

    public boolean isHandshakeComplete() {
        return this.mHandshakeComplete;
    }

    public void setHandshakeComplete() {
        this.mHandshakeComplete = true;
    }

    public void write(byte[] data, int length) throws IOException, TimeoutException {
        JdwpLoggingUtils.log("CLIENT", "WRITE", data, length);
        AdbHelper.write(this.mClientImplSocket, data, length, DdmPreferences.getTimeOut());
    }

    private void write(String value) throws IOException, TimeoutException {
        this.write(value.getBytes(Charset.defaultCharset()), value.length());
    }
}

