/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public enum CaseFormat {
    LOWER_HYPHEN(CharMatcher.is('-'), "-"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        @Override
        String convert(CaseFormat format, String s4) {
            if (format == LOWER_UNDERSCORE) {
                return s4.replace('-', '_');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s4.replace('-', '_'));
            }
            return super.convert(format, s4);
        }
    }
    ,
    LOWER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        @Override
        String convert(CaseFormat format, String s4) {
            if (format == LOWER_HYPHEN) {
                return s4.replace('_', '-');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s4);
            }
            return super.convert(format, s4);
        }
    }
    ,
    LOWER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }

        @Override
        String normalizeFirstWord(String word) {
            return Ascii.toLowerCase(word);
        }
    }
    ,
    UPPER_CAMEL(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }
    }
    ,
    UPPER_UNDERSCORE(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toUpperCase(word);
        }

        @Override
        String convert(CaseFormat format, String s4) {
            if (format == LOWER_HYPHEN) {
                return Ascii.toLowerCase(s4.replace('_', '-'));
            }
            if (format == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase(s4);
            }
            return super.convert(format, s4);
        }
    };

    private final CharMatcher wordBoundary;
    private final String wordSeparator;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public final String to(CaseFormat format, String str) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(str);
        return format == this ? str : this.convert(format, str);
    }

    String convert(CaseFormat format, String s4) {
        StringBuilder out = null;
        int i4 = 0;
        int j4 = -1;
        while (true) {
            ++j4;
            if ((j4 = this.wordBoundary.indexIn(s4, j4)) == -1) break;
            if (i4 == 0) {
                out = new StringBuilder(s4.length() + 4 * format.wordSeparator.length());
                out.append(format.normalizeFirstWord(s4.substring(i4, j4)));
            } else {
                out.append(format.normalizeWord(s4.substring(i4, j4)));
            }
            out.append(format.wordSeparator);
            i4 = j4 + this.wordSeparator.length();
        }
        return i4 == 0 ? format.normalizeFirstWord(s4) : out.append(format.normalizeWord(s4.substring(i4))).toString();
    }

    public Converter<String, String> converterTo(CaseFormat targetFormat) {
        return new StringConverter(this, targetFormat);
    }

    abstract String normalizeWord(String var1);

    String normalizeFirstWord(String word) {
        return this.normalizeWord(word);
    }

    private static String firstCharOnlyToUpper(String word) {
        String string;
        if (word.isEmpty()) {
            string = word;
        } else {
            char c5 = Ascii.toUpperCase(word.charAt(0));
            String string2 = Ascii.toLowerCase(word.substring(1));
            string = new StringBuilder(1 + String.valueOf(string2).length()).append(c5).append(string2).toString();
        }
        return string;
    }

    private static final class StringConverter
    extends Converter<String, String>
    implements Serializable {
        private final CaseFormat sourceFormat;
        private final CaseFormat targetFormat;
        private static final long serialVersionUID = 0L;

        StringConverter(CaseFormat sourceFormat, CaseFormat targetFormat) {
            this.sourceFormat = Preconditions.checkNotNull(sourceFormat);
            this.targetFormat = Preconditions.checkNotNull(targetFormat);
        }

        @Override
        protected String doForward(String s4) {
            return this.sourceFormat.to(this.targetFormat, s4);
        }

        @Override
        protected String doBackward(String s4) {
            return this.targetFormat.to(this.sourceFormat, s4);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof StringConverter) {
                StringConverter that = (StringConverter)object;
                return this.sourceFormat.equals((Object)that.sourceFormat) && this.targetFormat.equals((Object)that.targetFormat);
            }
            return false;
        }

        public int hashCode() {
            return this.sourceFormat.hashCode() ^ this.targetFormat.hashCode();
        }

        public String toString() {
            String string = String.valueOf((Object)this.sourceFormat);
            String string2 = String.valueOf((Object)this.targetFormat);
            return new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".converterTo(").append(string2).append(")").toString();
        }
    }
}

