/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string) {
        return Platform.nullToEmpty(string);
    }

    public static @Nullable String emptyToNull(@Nullable String string) {
        return Platform.emptyToNull(string);
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return Platform.stringIsNullOrEmpty(string);
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i4 = string.length(); i4 < minLength; ++i4) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i4 = string.length(); i4 < minLength; ++i4) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string, int count) {
        int n4;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(51).append("Required array size too large: ").append(longSize).toString());
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n4 = len; n4 < size - n4; n4 <<= 1) {
            System.arraycopy(array, 0, array, n4, n4);
        }
        System.arraycopy(array, 0, array, n4, size - n4);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a5, CharSequence b5) {
        int p4;
        Preconditions.checkNotNull(a5);
        Preconditions.checkNotNull(b5);
        int maxPrefixLength = Math.min(a5.length(), b5.length());
        for (p4 = 0; p4 < maxPrefixLength && a5.charAt(p4) == b5.charAt(p4); ++p4) {
        }
        if (Strings.validSurrogatePairAt(a5, p4 - 1) || Strings.validSurrogatePairAt(b5, p4 - 1)) {
            --p4;
        }
        return a5.subSequence(0, p4).toString();
    }

    public static String commonSuffix(CharSequence a5, CharSequence b5) {
        int s4;
        Preconditions.checkNotNull(a5);
        Preconditions.checkNotNull(b5);
        int maxSuffixLength = Math.min(a5.length(), b5.length());
        for (s4 = 0; s4 < maxSuffixLength && a5.charAt(a5.length() - s4 - 1) == b5.charAt(b5.length() - s4 - 1); ++s4) {
        }
        if (Strings.validSurrogatePairAt(a5, a5.length() - s4 - 1) || Strings.validSurrogatePairAt(b5, b5.length() - s4 - 1)) {
            --s4;
        }
        return a5.subSequence(a5.length() - s4, a5.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }

    public static String lenientFormat(@Nullable String template, Object ... args2) {
        int placeholderStart;
        template = String.valueOf(template);
        if (args2 == null) {
            args2 = new Object[]{"(Object[])null"};
        } else {
            for (int i4 = 0; i4 < args2.length; ++i4) {
                args2[i4] = Strings.lenientToString(args2[i4]);
            }
        }
        StringBuilder builder = new StringBuilder(template.length() + 16 * args2.length);
        int templateStart = 0;
        int i5 = 0;
        while (i5 < args2.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template, templateStart, placeholderStart);
            builder.append(args2[i5++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template, templateStart, template.length());
        if (i5 < args2.length) {
            builder.append(" [");
            builder.append(args2[i5++]);
            while (i5 < args2.length) {
                builder.append(", ");
                builder.append(args2[i5++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    private static String lenientToString(@Nullable Object o4) {
        if (o4 == null) {
            return "null";
        }
        try {
            return o4.toString();
        }
        catch (Exception e5) {
            String string = o4.getClass().getName();
            String string2 = Integer.toHexString(System.identityHashCode(o4));
            String objectToString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append('@').append(string2).toString();
            String string3 = String.valueOf(objectToString);
            Logger.getLogger("com.google.common.base.Strings").log(Level.WARNING, string3.length() != 0 ? "Exception during lenientFormat for ".concat(string3) : new String("Exception during lenientFormat for "), e5);
            string = e5.getClass().getName();
            return new StringBuilder(9 + String.valueOf(objectToString).length() + String.valueOf(string).length()).append("<").append(objectToString).append(" threw ").append(string).append(">").toString();
        }
    }
}

