/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractNonStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.LittleEndianByteArray;

final class FarmHashFingerprint64
extends AbstractNonStreamingHashFunction {
    static final HashFunction FARMHASH_FINGERPRINT_64 = new FarmHashFingerprint64();
    private static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    private static final long K2 = -7286425919675154353L;

    FarmHashFingerprint64() {
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        return HashCode.fromLong(FarmHashFingerprint64.fingerprint(input, off, len));
    }

    @Override
    public int bits() {
        return 64;
    }

    public String toString() {
        return "Hashing.farmHashFingerprint64()";
    }

    @VisibleForTesting
    static long fingerprint(byte[] bytes, int offset, int length) {
        if (length <= 32) {
            if (length <= 16) {
                return FarmHashFingerprint64.hashLength0to16(bytes, offset, length);
            }
            return FarmHashFingerprint64.hashLength17to32(bytes, offset, length);
        }
        if (length <= 64) {
            return FarmHashFingerprint64.hashLength33To64(bytes, offset, length);
        }
        return FarmHashFingerprint64.hashLength65Plus(bytes, offset, length);
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLength16(long u4, long v4, long mul) {
        long a5 = (u4 ^ v4) * mul;
        a5 ^= a5 >>> 47;
        long b5 = (v4 ^ a5) * mul;
        b5 ^= b5 >>> 47;
        return b5 *= mul;
    }

    private static void weakHashLength32WithSeeds(byte[] bytes, int offset, long seedA, long seedB, long[] output) {
        long part1 = LittleEndianByteArray.load64(bytes, offset);
        long part2 = LittleEndianByteArray.load64(bytes, offset + 8);
        long part3 = LittleEndianByteArray.load64(bytes, offset + 16);
        long part4 = LittleEndianByteArray.load64(bytes, offset + 24);
        seedB = Long.rotateRight(seedB + (seedA += part1) + part4, 21);
        long c5 = seedA;
        seedA += part2;
        output[0] = seedA + part4;
        output[1] = (seedB += Long.rotateRight(seedA += part3, 44)) + c5;
    }

    private static long hashLength0to16(byte[] bytes, int offset, int length) {
        if (length >= 8) {
            long mul = -7286425919675154353L + (long)(length * 2);
            long a5 = LittleEndianByteArray.load64(bytes, offset) + -7286425919675154353L;
            long b5 = LittleEndianByteArray.load64(bytes, offset + length - 8);
            long c5 = Long.rotateRight(b5, 37) * mul + a5;
            long d5 = (Long.rotateRight(a5, 25) + b5) * mul;
            return FarmHashFingerprint64.hashLength16(c5, d5, mul);
        }
        if (length >= 4) {
            long mul = -7286425919675154353L + (long)(length * 2);
            long a6 = (long)LittleEndianByteArray.load32(bytes, offset) & 0xFFFFFFFFL;
            return FarmHashFingerprint64.hashLength16((long)length + (a6 << 3), (long)LittleEndianByteArray.load32(bytes, offset + length - 4) & 0xFFFFFFFFL, mul);
        }
        if (length > 0) {
            byte a7 = bytes[offset];
            byte b6 = bytes[offset + (length >> 1)];
            byte c6 = bytes[offset + (length - 1)];
            int y4 = (a7 & 0xFF) + ((b6 & 0xFF) << 8);
            int z4 = length + ((c6 & 0xFF) << 2);
            return FarmHashFingerprint64.shiftMix((long)y4 * -7286425919675154353L ^ (long)z4 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLength17to32(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)(length * 2);
        long a5 = LittleEndianByteArray.load64(bytes, offset) * -5435081209227447693L;
        long b5 = LittleEndianByteArray.load64(bytes, offset + 8);
        long c5 = LittleEndianByteArray.load64(bytes, offset + length - 8) * mul;
        long d5 = LittleEndianByteArray.load64(bytes, offset + length - 16) * -7286425919675154353L;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(a5 + b5, 43) + Long.rotateRight(c5, 30) + d5, a5 + Long.rotateRight(b5 + -7286425919675154353L, 18) + c5, mul);
    }

    private static long hashLength33To64(byte[] bytes, int offset, int length) {
        long mul = -7286425919675154353L + (long)(length * 2);
        long a5 = LittleEndianByteArray.load64(bytes, offset) * -7286425919675154353L;
        long b5 = LittleEndianByteArray.load64(bytes, offset + 8);
        long c5 = LittleEndianByteArray.load64(bytes, offset + length - 8) * mul;
        long d5 = LittleEndianByteArray.load64(bytes, offset + length - 16) * -7286425919675154353L;
        long y4 = Long.rotateRight(a5 + b5, 43) + Long.rotateRight(c5, 30) + d5;
        long z4 = FarmHashFingerprint64.hashLength16(y4, a5 + Long.rotateRight(b5 + -7286425919675154353L, 18) + c5, mul);
        long e5 = LittleEndianByteArray.load64(bytes, offset + 16) * mul;
        long f5 = LittleEndianByteArray.load64(bytes, offset + 24);
        long g4 = (y4 + LittleEndianByteArray.load64(bytes, offset + length - 32)) * mul;
        long h4 = (z4 + LittleEndianByteArray.load64(bytes, offset + length - 24)) * mul;
        return FarmHashFingerprint64.hashLength16(Long.rotateRight(e5 + f5, 43) + Long.rotateRight(g4, 30) + h4, e5 + Long.rotateRight(f5 + a5, 18) + g4, mul);
    }

    private static long hashLength65Plus(byte[] bytes, int offset, int length) {
        int seed = 81;
        long x4 = 81L;
        long y4 = 2480279821605975764L;
        long z4 = FarmHashFingerprint64.shiftMix(y4 * -7286425919675154353L + 113L) * -7286425919675154353L;
        long[] v4 = new long[2];
        long[] w4 = new long[2];
        x4 = x4 * -7286425919675154353L + LittleEndianByteArray.load64(bytes, offset);
        int end = offset + (length - 1) / 64 * 64;
        int last64offset = end + (length - 1 & 0x3F) - 63;
        do {
            x4 = Long.rotateRight(x4 + y4 + v4[0] + LittleEndianByteArray.load64(bytes, offset + 8), 37) * -5435081209227447693L;
            y4 = Long.rotateRight(y4 + v4[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * -5435081209227447693L;
            z4 = Long.rotateRight(z4 + w4[0], 33) * -5435081209227447693L;
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset, v4[1] * -5435081209227447693L, (x4 ^= w4[1]) + w4[0], v4);
            FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset + 32, z4 + w4[1], (y4 += v4[0] + LittleEndianByteArray.load64(bytes, offset + 40)) + LittleEndianByteArray.load64(bytes, offset + 16), w4);
            long tmp = x4;
            x4 = z4;
            z4 = tmp;
        } while ((offset += 64) != end);
        long mul = -5435081209227447693L + ((z4 & 0xFFL) << 1);
        offset = last64offset;
        w4[0] = w4[0] + (long)(length - 1 & 0x3F);
        v4[0] = v4[0] + w4[0];
        w4[0] = w4[0] + v4[0];
        x4 = Long.rotateRight(x4 + y4 + v4[0] + LittleEndianByteArray.load64(bytes, offset + 8), 37) * mul;
        y4 = Long.rotateRight(y4 + v4[1] + LittleEndianByteArray.load64(bytes, offset + 48), 42) * mul;
        z4 = Long.rotateRight(z4 + w4[0], 33) * mul;
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset, v4[1] * mul, (x4 ^= w4[1] * 9L) + w4[0], v4);
        FarmHashFingerprint64.weakHashLength32WithSeeds(bytes, offset + 32, z4 + w4[1], (y4 += v4[0] * 9L + LittleEndianByteArray.load64(bytes, offset + 40)) + LittleEndianByteArray.load64(bytes, offset + 16), w4);
        return FarmHashFingerprint64.hashLength16(FarmHashFingerprint64.hashLength16(v4[0], w4[0], mul) + FarmHashFingerprint64.shiftMix(y4) * -4348849565147123417L + x4, FarmHashFingerprint64.hashLength16(v4[1], w4[1], mul) + z4, mul);
    }
}

