/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;
import org.bouncycastle.util.io.Streams;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int _originalLength;
    private int _remaining;

    DefiniteLengthInputStream(InputStream inputStream, int n4) {
        super(inputStream, n4);
        if (n4 < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._originalLength = n4;
        this._remaining = n4;
        if (n4 == 0) {
            this.setParentEofDetect(true);
        }
    }

    int getRemaining() {
        return this._remaining;
    }

    public int read() throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n4 = this._in.read();
        if (n4 < 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        if (--this._remaining == 0) {
            this.setParentEofDetect(true);
        }
        return n4;
    }

    public int read(byte[] byArray, int n4, int n5) throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n6 = Math.min(n5, this._remaining);
        int n7 = this._in.read(byArray, n4, n6);
        if (n7 < 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        if ((this._remaining -= n7) == 0) {
            this.setParentEofDetect(true);
        }
        return n7;
    }

    byte[] toByteArray() throws IOException {
        if (this._remaining == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[this._remaining];
        if ((this._remaining -= Streams.readFully(this._in, byArray)) != 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

