/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class BufferedAsymmetricBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    private final AsymmetricBlockCipher cipher;

    public BufferedAsymmetricBlockCipher(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.cipher = asymmetricBlockCipher;
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public int getBufferPosition() {
        return this.bufOff;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        this.reset();
        this.cipher.init(bl, cipherParameters);
        this.buf = new byte[this.cipher.getInputBlockSize() + (bl ? 1 : 0)];
        this.bufOff = 0;
    }

    public int getInputBlockSize() {
        return this.cipher.getInputBlockSize();
    }

    public int getOutputBlockSize() {
        return this.cipher.getOutputBlockSize();
    }

    public void processByte(byte by) {
        if (this.bufOff >= this.buf.length) {
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        this.buf[this.bufOff++] = by;
    }

    public void processBytes(byte[] byArray, int n4, int n5) {
        if (n5 == 0) {
            return;
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        if (this.bufOff + n5 > this.buf.length) {
            throw new DataLengthException("attempt to process message too long for cipher");
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
    }

    public byte[] doFinal() throws InvalidCipherTextException {
        byte[] byArray = this.cipher.processBlock(this.buf, 0, this.bufOff);
        this.reset();
        return byArray;
    }

    public void reset() {
        if (this.buf != null) {
            for (int i4 = 0; i4 < this.buf.length; ++i4) {
                this.buf[i4] = 0;
            }
        }
        this.bufOff = 0;
    }
}

