/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.StreamCipher;

public class BufferedBlockCipher {
    protected byte[] buf;
    protected int bufOff;
    protected boolean forEncryption;
    protected BlockCipher cipher;
    protected boolean partialBlockOkay;
    protected boolean pgpCFB;

    protected BufferedBlockCipher() {
    }

    public BufferedBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.buf = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
        String string = blockCipher.getAlgorithmName();
        int n4 = string.indexOf(47) + 1;
        boolean bl = this.pgpCFB = n4 > 0 && string.startsWith("PGP", n4);
        this.partialBlockOkay = this.pgpCFB || blockCipher instanceof StreamCipher ? true : n4 > 0 && string.startsWith("OpenPGP", n4);
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        this.cipher.init(bl, cipherParameters);
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public int getUpdateOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        int n6 = this.pgpCFB ? (this.forEncryption ? n5 % this.buf.length - (this.cipher.getBlockSize() + 2) : n5 % this.buf.length) : n5 % this.buf.length;
        return n5 - n6;
    }

    public int getOutputSize(int n4) {
        return n4 + this.bufOff;
    }

    public int processByte(byte by, byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        int n5 = 0;
        this.buf[this.bufOff++] = by;
        if (this.bufOff == this.buf.length) {
            n5 = this.cipher.processBlock(this.buf, 0, byArray, n4);
            this.bufOff = 0;
        }
        return n5;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException, IllegalStateException {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n7 = this.getBlockSize();
        int n8 = this.getUpdateOutputSize(n5);
        if (n8 > 0 && n6 + n8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n9 = 0;
        int n10 = this.buf.length - this.bufOff;
        if (n5 > n10) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n10);
            n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6);
            this.bufOff = 0;
            n5 -= n10;
            n4 += n10;
            while (n5 > this.buf.length) {
                n9 += this.cipher.processBlock(byArray, n4, byArray2, n6 + n9);
                n5 -= n7;
                n4 += n7;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
        if (this.bufOff == this.buf.length) {
            n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6 + n9);
            this.bufOff = 0;
        }
        return n9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        try {
            int n5 = 0;
            if (n4 + this.bufOff > byArray.length) {
                throw new OutputLengthException("output buffer too short for doFinal()");
            }
            if (this.bufOff != 0) {
                if (!this.partialBlockOkay) {
                    throw new DataLengthException("data not block size aligned");
                }
                this.cipher.processBlock(this.buf, 0, this.buf, 0);
                n5 = this.bufOff;
                this.bufOff = 0;
                System.arraycopy(this.buf, 0, byArray, n4, n5);
            }
            int n6 = n5;
            return n6;
        }
        finally {
            this.reset();
        }
    }

    public void reset() {
        for (int i4 = 0; i4 < this.buf.length; ++i4) {
            this.buf[i4] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

