/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.KeccakDigest;

public class SHAKEDigest
extends KeccakDigest
implements Xof {
    private static int checkBitLength(int n4) {
        switch (n4) {
            case 128: 
            case 256: {
                return n4;
            }
        }
        throw new IllegalArgumentException("'bitLength' " + n4 + " not supported for SHAKE");
    }

    public SHAKEDigest() {
        this(128);
    }

    public SHAKEDigest(int n4) {
        super(SHAKEDigest.checkBitLength(n4));
    }

    public SHAKEDigest(SHAKEDigest sHAKEDigest) {
        super(sHAKEDigest);
    }

    public String getAlgorithmName() {
        return "SHAKE" + this.fixedOutputLength;
    }

    public int doFinal(byte[] byArray, int n4) {
        return this.doFinal(byArray, n4, this.getDigestSize());
    }

    public int doFinal(byte[] byArray, int n4, int n5) {
        int n6 = this.doOutput(byArray, n4, n5);
        this.reset();
        return n6;
    }

    public int doOutput(byte[] byArray, int n4, int n5) {
        if (!this.squeezing) {
            this.absorb(new byte[]{15}, 0, 4L);
        }
        this.squeeze(byArray, n4, (long)n5 * 8L);
        return n5;
    }

    protected int doFinal(byte[] byArray, int n4, byte by, int n5) {
        return this.doFinal(byArray, n4, this.getDigestSize(), by, n5);
    }

    protected int doFinal(byte[] byArray, int n4, int n5, byte by, int n6) {
        if (n6 < 0 || n6 > 7) {
            throw new IllegalArgumentException("'partialBits' must be in the range [0,7]");
        }
        int n7 = by & (1 << n6) - 1 | 15 << n6;
        int n8 = n6 + 4;
        if (n8 >= 8) {
            this.oneByte[0] = (byte)n7;
            this.absorb(this.oneByte, 0, 8L);
            n8 -= 8;
            n7 >>>= 8;
        }
        if (n8 > 0) {
            this.oneByte[0] = (byte)n7;
            this.absorb(this.oneByte, 0, n8);
        }
        this.squeeze(byArray, n4, (long)n5 * 8L);
        this.reset();
        return n5;
    }
}

