/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.util.Arrays;

public class OAEPEncoding
implements AsymmetricBlockCipher {
    private byte[] defHash;
    private Digest mgf1Hash;
    private AsymmetricBlockCipher engine;
    private SecureRandom random;
    private boolean forEncryption;

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this(asymmetricBlockCipher, DigestFactory.createSHA1(), null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, null);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, byte[] byArray) {
        this(asymmetricBlockCipher, digest, digest, byArray);
    }

    public OAEPEncoding(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, byte[] byArray) {
        this.engine = asymmetricBlockCipher;
        this.mgf1Hash = digest2;
        this.defHash = new byte[digest.getDigestSize()];
        digest.reset();
        if (byArray != null) {
            digest.update(byArray, 0, byArray.length);
        }
        digest.doFinal(this.defHash, 0);
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.engine;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.random = parametersWithRandom.getRandom();
        } else {
            this.random = new SecureRandom();
        }
        this.engine.init(bl, cipherParameters);
        this.forEncryption = bl;
    }

    public int getInputBlockSize() {
        int n4 = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n4 - 1 - 2 * this.defHash.length;
        }
        return n4;
    }

    public int getOutputBlockSize() {
        int n4 = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n4;
        }
        return n4 - 1 - 2 * this.defHash.length;
    }

    public byte[] processBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encodeBlock(byArray, n4, n5);
        }
        return this.decodeBlock(byArray, n4, n5);
    }

    public byte[] encodeBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        int n6;
        if (n5 > this.getInputBlockSize()) {
            throw new DataLengthException("input data too long");
        }
        byte[] byArray2 = new byte[this.getInputBlockSize() + 1 + 2 * this.defHash.length];
        System.arraycopy(byArray, n4, byArray2, byArray2.length - n5, n5);
        byArray2[byArray2.length - n5 - 1] = 1;
        System.arraycopy(this.defHash, 0, byArray2, this.defHash.length, this.defHash.length);
        byte[] byArray3 = new byte[this.defHash.length];
        this.random.nextBytes(byArray3);
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, 0, byArray3.length, byArray2.length - this.defHash.length);
        for (n6 = this.defHash.length; n6 != byArray2.length; ++n6) {
            int n7 = n6;
            byArray2[n7] = (byte)(byArray2[n7] ^ byArray4[n6 - this.defHash.length]);
        }
        System.arraycopy(byArray3, 0, byArray2, 0, this.defHash.length);
        byArray4 = this.maskGeneratorFunction1(byArray2, this.defHash.length, byArray2.length - this.defHash.length, this.defHash.length);
        for (n6 = 0; n6 != this.defHash.length; ++n6) {
            int n8 = n6;
            byArray2[n8] = (byte)(byArray2[n8] ^ byArray4[n6]);
        }
        return this.engine.processBlock(byArray2, 0, byArray2.length);
    }

    public byte[] decodeBlock(byte[] byArray, int n4, int n5) throws InvalidCipherTextException {
        int n6;
        int n7;
        int n8;
        byte[] byArray2 = this.engine.processBlock(byArray, n4, n5);
        byte[] byArray3 = new byte[this.engine.getOutputBlockSize()];
        System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
        int n9 = byArray3.length < 2 * this.defHash.length + 1 ? 1 : 0;
        byte[] byArray4 = this.maskGeneratorFunction1(byArray3, this.defHash.length, byArray3.length - this.defHash.length, this.defHash.length);
        for (n8 = 0; n8 != this.defHash.length; ++n8) {
            int n10 = n8;
            byArray3[n10] = (byte)(byArray3[n10] ^ byArray4[n8]);
        }
        byArray4 = this.maskGeneratorFunction1(byArray3, 0, this.defHash.length, byArray3.length - this.defHash.length);
        for (n8 = this.defHash.length; n8 != byArray3.length; ++n8) {
            int n11 = n8;
            byArray3[n11] = (byte)(byArray3[n11] ^ byArray4[n8 - this.defHash.length]);
        }
        n8 = 0;
        for (n7 = 0; n7 != this.defHash.length; ++n7) {
            if (this.defHash[n7] == byArray3[this.defHash.length + n7]) continue;
            n8 = 1;
        }
        n7 = byArray3.length;
        for (n6 = 2 * this.defHash.length; n6 != byArray3.length; ++n6) {
            if (!(byArray3[n6] != 0 & n7 == byArray3.length)) continue;
            n7 = n6;
        }
        n6 = (n7 > byArray3.length - 1 ? 1 : 0) | (byArray3[n7] != 1 ? 1 : 0);
        ++n7;
        if ((n8 | n9 | n6) != 0) {
            Arrays.fill(byArray3, (byte)0);
            throw new InvalidCipherTextException("data wrong");
        }
        byte[] byArray5 = new byte[byArray3.length - n7];
        System.arraycopy(byArray3, n7, byArray5, 0, byArray5.length);
        return byArray5;
    }

    private void ItoOSP(int n4, byte[] byArray) {
        byArray[0] = (byte)(n4 >>> 24);
        byArray[1] = (byte)(n4 >>> 16);
        byArray[2] = (byte)(n4 >>> 8);
        byArray[3] = (byte)(n4 >>> 0);
    }

    private byte[] maskGeneratorFunction1(byte[] byArray, int n4, int n5, int n6) {
        int n7;
        byte[] byArray2 = new byte[n6];
        byte[] byArray3 = new byte[this.mgf1Hash.getDigestSize()];
        byte[] byArray4 = new byte[4];
        this.mgf1Hash.reset();
        for (n7 = 0; n7 < n6 / byArray3.length; ++n7) {
            this.ItoOSP(n7, byArray4);
            this.mgf1Hash.update(byArray, n4, n5);
            this.mgf1Hash.update(byArray4, 0, byArray4.length);
            this.mgf1Hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n7 * byArray3.length, byArray3.length);
        }
        if (n7 * byArray3.length < n6) {
            this.ItoOSP(n7, byArray4);
            this.mgf1Hash.update(byArray, n4, n5);
            this.mgf1Hash.update(byArray4, 0, byArray4.length);
            this.mgf1Hash.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n7 * byArray3.length, byArray2.length - n7 * byArray3.length);
        }
        return byArray2;
    }
}

