/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.TweakableBlockCipherParameters;

public class ThreefishEngine
implements BlockCipher {
    public static final int BLOCKSIZE_256 = 256;
    public static final int BLOCKSIZE_512 = 512;
    public static final int BLOCKSIZE_1024 = 1024;
    private static final int TWEAK_SIZE_BYTES = 16;
    private static final int TWEAK_SIZE_WORDS = 2;
    private static final int ROUNDS_256 = 72;
    private static final int ROUNDS_512 = 72;
    private static final int ROUNDS_1024 = 80;
    private static final int MAX_ROUNDS = 80;
    private static final long C_240 = 2004413935125273122L;
    private static int[] MOD9 = new int[80];
    private static int[] MOD17 = new int[MOD9.length];
    private static int[] MOD5 = new int[MOD9.length];
    private static int[] MOD3 = new int[MOD9.length];
    private int blocksizeBytes;
    private int blocksizeWords;
    private long[] currentBlock;
    private long[] t = new long[5];
    private long[] kw;
    private ThreefishCipher cipher;
    private boolean forEncryption;

    public ThreefishEngine(int n4) {
        this.blocksizeBytes = n4 / 8;
        this.blocksizeWords = this.blocksizeBytes / 8;
        this.currentBlock = new long[this.blocksizeWords];
        this.kw = new long[2 * this.blocksizeWords + 1];
        switch (n4) {
            case 256: {
                this.cipher = new Threefish256Cipher(this.kw, this.t);
                break;
            }
            case 512: {
                this.cipher = new Threefish512Cipher(this.kw, this.t);
                break;
            }
            case 1024: {
                this.cipher = new Threefish1024Cipher(this.kw, this.t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid blocksize - Threefish is defined with block size of 256, 512, or 1024 bits");
            }
        }
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (cipherParameters instanceof TweakableBlockCipherParameters) {
            object = (TweakableBlockCipherParameters)cipherParameters;
            byArray2 = ((TweakableBlockCipherParameters)object).getKey().getKey();
            byArray = ((TweakableBlockCipherParameters)object).getTweak();
        } else if (cipherParameters instanceof KeyParameter) {
            byArray2 = ((KeyParameter)cipherParameters).getKey();
            byArray = null;
        } else {
            throw new IllegalArgumentException("Invalid parameter passed to Threefish init - " + cipherParameters.getClass().getName());
        }
        object = null;
        long[] lArray = null;
        if (byArray2 != null) {
            if (byArray2.length != this.blocksizeBytes) {
                throw new IllegalArgumentException("Threefish key must be same size as block (" + this.blocksizeBytes + " bytes)");
            }
            object = new long[this.blocksizeWords];
            for (int i4 = 0; i4 < ((Object)object).length; ++i4) {
                object[i4] = ThreefishEngine.bytesToWord(byArray2, i4 * 8);
            }
        }
        if (byArray != null) {
            if (byArray.length != 16) {
                throw new IllegalArgumentException("Threefish tweak must be 16 bytes");
            }
            lArray = new long[]{ThreefishEngine.bytesToWord(byArray, 0), ThreefishEngine.bytesToWord(byArray, 8)};
        }
        this.init(bl, (long[])object, lArray);
    }

    public void init(boolean bl, long[] lArray, long[] lArray2) {
        this.forEncryption = bl;
        if (lArray != null) {
            this.setKey(lArray);
        }
        if (lArray2 != null) {
            this.setTweak(lArray2);
        }
    }

    private void setKey(long[] lArray) {
        if (lArray.length != this.blocksizeWords) {
            throw new IllegalArgumentException("Threefish key must be same size as block (" + this.blocksizeWords + " words)");
        }
        long l4 = 2004413935125273122L;
        for (int i4 = 0; i4 < this.blocksizeWords; ++i4) {
            this.kw[i4] = lArray[i4];
            l4 ^= this.kw[i4];
        }
        this.kw[this.blocksizeWords] = l4;
        System.arraycopy(this.kw, 0, this.kw, this.blocksizeWords + 1, this.blocksizeWords);
    }

    private void setTweak(long[] lArray) {
        if (lArray.length != 2) {
            throw new IllegalArgumentException("Tweak must be 2 words.");
        }
        this.t[0] = lArray[0];
        this.t[1] = lArray[1];
        this.t[2] = this.t[0] ^ this.t[1];
        this.t[3] = this.t[0];
        this.t[4] = this.t[1];
    }

    public String getAlgorithmName() {
        return "Threefish-" + this.blocksizeBytes * 8;
    }

    public int getBlockSize() {
        return this.blocksizeBytes;
    }

    public void reset() {
    }

    public int processBlock(byte[] byArray, int n4, byte[] byArray2, int n5) throws DataLengthException, IllegalStateException {
        int n6;
        if (n5 + this.blocksizeBytes > byArray2.length) {
            throw new DataLengthException("Output buffer too short");
        }
        if (n4 + this.blocksizeBytes > byArray.length) {
            throw new DataLengthException("Input buffer too short");
        }
        for (n6 = 0; n6 < this.blocksizeBytes; n6 += 8) {
            this.currentBlock[n6 >> 3] = ThreefishEngine.bytesToWord(byArray, n4 + n6);
        }
        this.processBlock(this.currentBlock, this.currentBlock);
        for (n6 = 0; n6 < this.blocksizeBytes; n6 += 8) {
            ThreefishEngine.wordToBytes(this.currentBlock[n6 >> 3], byArray2, n5 + n6);
        }
        return this.blocksizeBytes;
    }

    public int processBlock(long[] lArray, long[] lArray2) throws DataLengthException, IllegalStateException {
        if (this.kw[this.blocksizeWords] == 0L) {
            throw new IllegalStateException("Threefish engine not initialised");
        }
        if (lArray.length != this.blocksizeWords) {
            throw new DataLengthException("Input buffer too short");
        }
        if (lArray2.length != this.blocksizeWords) {
            throw new DataLengthException("Output buffer too short");
        }
        if (this.forEncryption) {
            this.cipher.encryptBlock(lArray, lArray2);
        } else {
            this.cipher.decryptBlock(lArray, lArray2);
        }
        return this.blocksizeWords;
    }

    public static long bytesToWord(byte[] byArray, int n4) {
        if (n4 + 8 > byArray.length) {
            throw new IllegalArgumentException();
        }
        long l4 = 0L;
        int n5 = n4;
        l4 = (long)byArray[n5++] & 0xFFL;
        l4 |= ((long)byArray[n5++] & 0xFFL) << 8;
        l4 |= ((long)byArray[n5++] & 0xFFL) << 16;
        l4 |= ((long)byArray[n5++] & 0xFFL) << 24;
        l4 |= ((long)byArray[n5++] & 0xFFL) << 32;
        l4 |= ((long)byArray[n5++] & 0xFFL) << 40;
        l4 |= ((long)byArray[n5++] & 0xFFL) << 48;
        return l4 |= ((long)byArray[n5++] & 0xFFL) << 56;
    }

    public static void wordToBytes(long l4, byte[] byArray, int n4) {
        if (n4 + 8 > byArray.length) {
            throw new IllegalArgumentException();
        }
        int n5 = n4;
        byArray[n5++] = (byte)l4;
        byArray[n5++] = (byte)(l4 >> 8);
        byArray[n5++] = (byte)(l4 >> 16);
        byArray[n5++] = (byte)(l4 >> 24);
        byArray[n5++] = (byte)(l4 >> 32);
        byArray[n5++] = (byte)(l4 >> 40);
        byArray[n5++] = (byte)(l4 >> 48);
        byArray[n5++] = (byte)(l4 >> 56);
    }

    static long rotlXor(long l4, int n4, long l5) {
        return (l4 << n4 | l4 >>> -n4) ^ l5;
    }

    static long xorRotr(long l4, int n4, long l5) {
        long l6 = l4 ^ l5;
        return l6 >>> n4 | l6 << -n4;
    }

    static {
        for (int i4 = 0; i4 < MOD9.length; ++i4) {
            ThreefishEngine.MOD17[i4] = i4 % 17;
            ThreefishEngine.MOD9[i4] = i4 % 9;
            ThreefishEngine.MOD5[i4] = i4 % 5;
            ThreefishEngine.MOD3[i4] = i4 % 3;
        }
    }

    private static final class Threefish1024Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 24;
        private static final int ROTATION_0_1 = 13;
        private static final int ROTATION_0_2 = 8;
        private static final int ROTATION_0_3 = 47;
        private static final int ROTATION_0_4 = 8;
        private static final int ROTATION_0_5 = 17;
        private static final int ROTATION_0_6 = 22;
        private static final int ROTATION_0_7 = 37;
        private static final int ROTATION_1_0 = 38;
        private static final int ROTATION_1_1 = 19;
        private static final int ROTATION_1_2 = 10;
        private static final int ROTATION_1_3 = 55;
        private static final int ROTATION_1_4 = 49;
        private static final int ROTATION_1_5 = 18;
        private static final int ROTATION_1_6 = 23;
        private static final int ROTATION_1_7 = 52;
        private static final int ROTATION_2_0 = 33;
        private static final int ROTATION_2_1 = 4;
        private static final int ROTATION_2_2 = 51;
        private static final int ROTATION_2_3 = 13;
        private static final int ROTATION_2_4 = 34;
        private static final int ROTATION_2_5 = 41;
        private static final int ROTATION_2_6 = 59;
        private static final int ROTATION_2_7 = 17;
        private static final int ROTATION_3_0 = 5;
        private static final int ROTATION_3_1 = 20;
        private static final int ROTATION_3_2 = 48;
        private static final int ROTATION_3_3 = 41;
        private static final int ROTATION_3_4 = 47;
        private static final int ROTATION_3_5 = 28;
        private static final int ROTATION_3_6 = 16;
        private static final int ROTATION_3_7 = 25;
        private static final int ROTATION_4_0 = 41;
        private static final int ROTATION_4_1 = 9;
        private static final int ROTATION_4_2 = 37;
        private static final int ROTATION_4_3 = 31;
        private static final int ROTATION_4_4 = 12;
        private static final int ROTATION_4_5 = 47;
        private static final int ROTATION_4_6 = 44;
        private static final int ROTATION_4_7 = 30;
        private static final int ROTATION_5_0 = 16;
        private static final int ROTATION_5_1 = 34;
        private static final int ROTATION_5_2 = 56;
        private static final int ROTATION_5_3 = 51;
        private static final int ROTATION_5_4 = 4;
        private static final int ROTATION_5_5 = 53;
        private static final int ROTATION_5_6 = 42;
        private static final int ROTATION_5_7 = 41;
        private static final int ROTATION_6_0 = 31;
        private static final int ROTATION_6_1 = 44;
        private static final int ROTATION_6_2 = 47;
        private static final int ROTATION_6_3 = 46;
        private static final int ROTATION_6_4 = 19;
        private static final int ROTATION_6_5 = 42;
        private static final int ROTATION_6_6 = 44;
        private static final int ROTATION_6_7 = 25;
        private static final int ROTATION_7_0 = 9;
        private static final int ROTATION_7_1 = 48;
        private static final int ROTATION_7_2 = 35;
        private static final int ROTATION_7_3 = 52;
        private static final int ROTATION_7_4 = 23;
        private static final int ROTATION_7_5 = 31;
        private static final int ROTATION_7_6 = 37;
        private static final int ROTATION_7_7 = 20;

        public Threefish1024Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        void encryptBlock(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.kw;
            long[] lArray4 = this.t;
            int[] nArray = MOD17;
            int[] nArray2 = MOD3;
            if (lArray3.length != 33) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l4 = lArray[0];
            long l5 = lArray[1];
            long l6 = lArray[2];
            long l7 = lArray[3];
            long l8 = lArray[4];
            long l9 = lArray[5];
            long l10 = lArray[6];
            long l11 = lArray[7];
            long l12 = lArray[8];
            long l13 = lArray[9];
            long l14 = lArray[10];
            long l15 = lArray[11];
            long l16 = lArray[12];
            long l17 = lArray[13];
            long l18 = lArray[14];
            long l19 = lArray[15];
            l4 += lArray3[0];
            l5 += lArray3[1];
            l6 += lArray3[2];
            l7 += lArray3[3];
            l8 += lArray3[4];
            l9 += lArray3[5];
            l10 += lArray3[6];
            l11 += lArray3[7];
            l12 += lArray3[8];
            l13 += lArray3[9];
            l14 += lArray3[10];
            l15 += lArray3[11];
            l16 += lArray3[12];
            l17 += lArray3[13] + lArray4[0];
            l18 += lArray3[14] + lArray4[1];
            l19 += lArray3[15];
            for (int i4 = 1; i4 < 20; i4 += 2) {
                int n4 = nArray[i4];
                int n5 = nArray2[i4];
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 24, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 13, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 8, l8);
                l10 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 47, l10);
                l12 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 8, l12);
                l14 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 17, l14);
                l16 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 22, l16);
                l18 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 37, l18);
                l4 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 38, l4);
                l6 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 19, l6);
                l10 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 10, l10);
                l8 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 55, l8);
                l14 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 49, l14);
                l16 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 18, l16);
                l18 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 23, l18);
                l12 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 52, l12);
                l4 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 33, l4);
                l6 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 4, l6);
                l8 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 51, l8);
                l10 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 13, l10);
                l16 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 34, l16);
                l18 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 41, l18);
                l12 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 59, l12);
                l14 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 17, l14);
                l4 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 5, l4);
                l6 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 20, l6);
                l10 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 48, l10);
                l8 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 41, l8);
                l18 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 47, l18);
                l12 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 28, l12);
                l14 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 16, l14);
                l16 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 25, l16);
                l4 += lArray3[n4];
                l5 += lArray3[n4 + 1];
                l6 += lArray3[n4 + 2];
                l7 += lArray3[n4 + 3];
                l8 += lArray3[n4 + 4];
                l9 += lArray3[n4 + 5];
                l10 += lArray3[n4 + 6];
                l11 += lArray3[n4 + 7];
                l12 += lArray3[n4 + 8];
                l13 += lArray3[n4 + 9];
                l14 += lArray3[n4 + 10];
                l15 += lArray3[n4 + 11];
                l16 += lArray3[n4 + 12];
                l17 += lArray3[n4 + 13] + lArray4[n5];
                l18 += lArray3[n4 + 14] + lArray4[n5 + 1];
                l19 += lArray3[n4 + 15] + (long)i4;
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 41, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 9, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 37, l8);
                l10 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 31, l10);
                l12 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 12, l12);
                l14 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 47, l14);
                l16 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 44, l16);
                l18 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 30, l18);
                l4 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 16, l4);
                l6 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 34, l6);
                l10 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 56, l10);
                l8 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 51, l8);
                l14 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 4, l14);
                l16 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 53, l16);
                l18 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 42, l18);
                l12 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 41, l12);
                l4 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 31, l4);
                l6 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 44, l6);
                l8 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 47, l8);
                l10 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 46, l10);
                l16 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 19, l16);
                l18 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 42, l18);
                l12 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 44, l12);
                l14 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 25, l14);
                l4 += l19;
                l19 = ThreefishEngine.rotlXor(l19, 9, l4);
                l6 += l15;
                l15 = ThreefishEngine.rotlXor(l15, 48, l6);
                l10 += l17;
                l17 = ThreefishEngine.rotlXor(l17, 35, l10);
                l8 += l13;
                l13 = ThreefishEngine.rotlXor(l13, 52, l8);
                l18 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 23, l18);
                l12 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 31, l12);
                l14 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 37, l14);
                l16 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 20, l16);
                l4 += lArray3[n4 + 1];
                l5 += lArray3[n4 + 2];
                l6 += lArray3[n4 + 3];
                l7 += lArray3[n4 + 4];
                l8 += lArray3[n4 + 5];
                l9 += lArray3[n4 + 6];
                l10 += lArray3[n4 + 7];
                l11 += lArray3[n4 + 8];
                l12 += lArray3[n4 + 9];
                l13 += lArray3[n4 + 10];
                l14 += lArray3[n4 + 11];
                l15 += lArray3[n4 + 12];
                l16 += lArray3[n4 + 13];
                l17 += lArray3[n4 + 14] + lArray4[n5 + 1];
                l18 += lArray3[n4 + 15] + lArray4[n5 + 2];
                l19 += lArray3[n4 + 16] + (long)i4 + 1L;
            }
            lArray2[0] = l4;
            lArray2[1] = l5;
            lArray2[2] = l6;
            lArray2[3] = l7;
            lArray2[4] = l8;
            lArray2[5] = l9;
            lArray2[6] = l10;
            lArray2[7] = l11;
            lArray2[8] = l12;
            lArray2[9] = l13;
            lArray2[10] = l14;
            lArray2[11] = l15;
            lArray2[12] = l16;
            lArray2[13] = l17;
            lArray2[14] = l18;
            lArray2[15] = l19;
        }

        void decryptBlock(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.kw;
            long[] lArray4 = this.t;
            int[] nArray = MOD17;
            int[] nArray2 = MOD3;
            if (lArray3.length != 33) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l4 = lArray[0];
            long l5 = lArray[1];
            long l6 = lArray[2];
            long l7 = lArray[3];
            long l8 = lArray[4];
            long l9 = lArray[5];
            long l10 = lArray[6];
            long l11 = lArray[7];
            long l12 = lArray[8];
            long l13 = lArray[9];
            long l14 = lArray[10];
            long l15 = lArray[11];
            long l16 = lArray[12];
            long l17 = lArray[13];
            long l18 = lArray[14];
            long l19 = lArray[15];
            for (int i4 = 19; i4 >= 1; i4 -= 2) {
                int n4 = nArray[i4];
                int n5 = nArray2[i4];
                l4 -= lArray3[n4 + 1];
                l5 -= lArray3[n4 + 2];
                l6 -= lArray3[n4 + 3];
                l7 -= lArray3[n4 + 4];
                l8 -= lArray3[n4 + 5];
                l9 -= lArray3[n4 + 6];
                l10 -= lArray3[n4 + 7];
                l11 -= lArray3[n4 + 8];
                l12 -= lArray3[n4 + 9];
                l13 -= lArray3[n4 + 10];
                l14 -= lArray3[n4 + 11];
                l15 -= lArray3[n4 + 12];
                l16 -= lArray3[n4 + 13];
                l17 -= lArray3[n4 + 14] + lArray4[n5 + 1];
                l18 -= lArray3[n4 + 15] + lArray4[n5 + 2];
                l19 -= lArray3[n4 + 16] + (long)i4 + 1L;
                l19 = ThreefishEngine.xorRotr(l19, 9, l4);
                l4 -= l19;
                l15 = ThreefishEngine.xorRotr(l15, 48, l6);
                l6 -= l15;
                l17 = ThreefishEngine.xorRotr(l17, 35, l10);
                l10 -= l17;
                l13 = ThreefishEngine.xorRotr(l13, 52, l8);
                l8 -= l13;
                l5 = ThreefishEngine.xorRotr(l5, 23, l18);
                l18 -= l5;
                l9 = ThreefishEngine.xorRotr(l9, 31, l12);
                l12 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 37, l14);
                l14 -= l7;
                l11 = ThreefishEngine.xorRotr(l11, 20, l16);
                l16 -= l11;
                l11 = ThreefishEngine.xorRotr(l11, 31, l4);
                l4 -= l11;
                l9 = ThreefishEngine.xorRotr(l9, 44, l6);
                l6 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 47, l8);
                l8 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 46, l10);
                l10 -= l5;
                l19 = ThreefishEngine.xorRotr(l19, 19, l16);
                l16 -= l19;
                l17 = ThreefishEngine.xorRotr(l17, 42, l18);
                l18 -= l17;
                l15 = ThreefishEngine.xorRotr(l15, 44, l12);
                l12 -= l15;
                l13 = ThreefishEngine.xorRotr(l13, 25, l14);
                l14 -= l13;
                l13 = ThreefishEngine.xorRotr(l13, 16, l4);
                l4 -= l13;
                l17 = ThreefishEngine.xorRotr(l17, 34, l6);
                l6 -= l17;
                l15 = ThreefishEngine.xorRotr(l15, 56, l10);
                l10 -= l15;
                l19 = ThreefishEngine.xorRotr(l19, 51, l8);
                l8 -= l19;
                l11 = ThreefishEngine.xorRotr(l11, 4, l14);
                l14 -= l11;
                l7 = ThreefishEngine.xorRotr(l7, 53, l16);
                l16 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 42, l18);
                l18 -= l9;
                l5 = ThreefishEngine.xorRotr(l5, 41, l12);
                l12 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 41, l4);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 9, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 37, l8);
                l8 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 31, l10);
                l10 -= l11;
                l13 = ThreefishEngine.xorRotr(l13, 12, l12);
                l12 -= l13;
                l15 = ThreefishEngine.xorRotr(l15, 47, l14);
                l14 -= l15;
                l17 = ThreefishEngine.xorRotr(l17, 44, l16);
                l16 -= l17;
                l19 = ThreefishEngine.xorRotr(l19, 30, l18);
                l18 -= l19;
                l4 -= lArray3[n4];
                l5 -= lArray3[n4 + 1];
                l6 -= lArray3[n4 + 2];
                l7 -= lArray3[n4 + 3];
                l8 -= lArray3[n4 + 4];
                l9 -= lArray3[n4 + 5];
                l10 -= lArray3[n4 + 6];
                l11 -= lArray3[n4 + 7];
                l12 -= lArray3[n4 + 8];
                l13 -= lArray3[n4 + 9];
                l14 -= lArray3[n4 + 10];
                l15 -= lArray3[n4 + 11];
                l16 -= lArray3[n4 + 12];
                l17 -= lArray3[n4 + 13] + lArray4[n5];
                l18 -= lArray3[n4 + 14] + lArray4[n5 + 1];
                l19 -= lArray3[n4 + 15] + (long)i4;
                l19 = ThreefishEngine.xorRotr(l19, 5, l4);
                l4 -= l19;
                l15 = ThreefishEngine.xorRotr(l15, 20, l6);
                l6 -= l15;
                l17 = ThreefishEngine.xorRotr(l17, 48, l10);
                l10 -= l17;
                l13 = ThreefishEngine.xorRotr(l13, 41, l8);
                l8 -= l13;
                l5 = ThreefishEngine.xorRotr(l5, 47, l18);
                l18 -= l5;
                l9 = ThreefishEngine.xorRotr(l9, 28, l12);
                l12 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 16, l14);
                l14 -= l7;
                l11 = ThreefishEngine.xorRotr(l11, 25, l16);
                l16 -= l11;
                l11 = ThreefishEngine.xorRotr(l11, 33, l4);
                l4 -= l11;
                l9 = ThreefishEngine.xorRotr(l9, 4, l6);
                l6 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 51, l8);
                l8 -= l7;
                l5 = ThreefishEngine.xorRotr(l5, 13, l10);
                l10 -= l5;
                l19 = ThreefishEngine.xorRotr(l19, 34, l16);
                l16 -= l19;
                l17 = ThreefishEngine.xorRotr(l17, 41, l18);
                l18 -= l17;
                l15 = ThreefishEngine.xorRotr(l15, 59, l12);
                l12 -= l15;
                l13 = ThreefishEngine.xorRotr(l13, 17, l14);
                l14 -= l13;
                l13 = ThreefishEngine.xorRotr(l13, 38, l4);
                l4 -= l13;
                l17 = ThreefishEngine.xorRotr(l17, 19, l6);
                l6 -= l17;
                l15 = ThreefishEngine.xorRotr(l15, 10, l10);
                l10 -= l15;
                l19 = ThreefishEngine.xorRotr(l19, 55, l8);
                l8 -= l19;
                l11 = ThreefishEngine.xorRotr(l11, 49, l14);
                l14 -= l11;
                l7 = ThreefishEngine.xorRotr(l7, 18, l16);
                l16 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 23, l18);
                l18 -= l9;
                l5 = ThreefishEngine.xorRotr(l5, 52, l12);
                l12 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 24, l4);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 13, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 8, l8);
                l8 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 47, l10);
                l10 -= l11;
                l13 = ThreefishEngine.xorRotr(l13, 8, l12);
                l12 -= l13;
                l15 = ThreefishEngine.xorRotr(l15, 17, l14);
                l14 -= l15;
                l17 = ThreefishEngine.xorRotr(l17, 22, l16);
                l16 -= l17;
                l19 = ThreefishEngine.xorRotr(l19, 37, l18);
                l18 -= l19;
            }
            l4 -= lArray3[0];
            l5 -= lArray3[1];
            l6 -= lArray3[2];
            l7 -= lArray3[3];
            l8 -= lArray3[4];
            l9 -= lArray3[5];
            l10 -= lArray3[6];
            l11 -= lArray3[7];
            l12 -= lArray3[8];
            l13 -= lArray3[9];
            l14 -= lArray3[10];
            l15 -= lArray3[11];
            l16 -= lArray3[12];
            l17 -= lArray3[13] + lArray4[0];
            l18 -= lArray3[14] + lArray4[1];
            l19 -= lArray3[15];
            lArray2[0] = l4;
            lArray2[1] = l5;
            lArray2[2] = l6;
            lArray2[3] = l7;
            lArray2[4] = l8;
            lArray2[5] = l9;
            lArray2[6] = l10;
            lArray2[7] = l11;
            lArray2[8] = l12;
            lArray2[9] = l13;
            lArray2[10] = l14;
            lArray2[11] = l15;
            lArray2[12] = l16;
            lArray2[13] = l17;
            lArray2[14] = l18;
            lArray2[15] = l19;
        }
    }

    private static final class Threefish256Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 14;
        private static final int ROTATION_0_1 = 16;
        private static final int ROTATION_1_0 = 52;
        private static final int ROTATION_1_1 = 57;
        private static final int ROTATION_2_0 = 23;
        private static final int ROTATION_2_1 = 40;
        private static final int ROTATION_3_0 = 5;
        private static final int ROTATION_3_1 = 37;
        private static final int ROTATION_4_0 = 25;
        private static final int ROTATION_4_1 = 33;
        private static final int ROTATION_5_0 = 46;
        private static final int ROTATION_5_1 = 12;
        private static final int ROTATION_6_0 = 58;
        private static final int ROTATION_6_1 = 22;
        private static final int ROTATION_7_0 = 32;
        private static final int ROTATION_7_1 = 32;

        public Threefish256Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        void encryptBlock(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.kw;
            long[] lArray4 = this.t;
            int[] nArray = MOD5;
            int[] nArray2 = MOD3;
            if (lArray3.length != 9) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l4 = lArray[0];
            long l5 = lArray[1];
            long l6 = lArray[2];
            long l7 = lArray[3];
            l4 += lArray3[0];
            l5 += lArray3[1] + lArray4[0];
            l6 += lArray3[2] + lArray4[1];
            l7 += lArray3[3];
            for (int i4 = 1; i4 < 18; i4 += 2) {
                int n4 = nArray[i4];
                int n5 = nArray2[i4];
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 14, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 16, l6);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 52, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 57, l6);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 23, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 40, l6);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 5, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 37, l6);
                l4 += lArray3[n4];
                l6 += lArray3[n4 + 2] + lArray4[n5 + 1];
                l5 = ThreefishEngine.rotlXor(l5, 25, l4 += (l5 += lArray3[n4 + 1] + lArray4[n5]));
                l7 = ThreefishEngine.rotlXor(l7, 33, l6 += (l7 += lArray3[n4 + 3] + (long)i4));
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 46, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 12, l6);
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 58, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 22, l6);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 32, l4);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 32, l6);
                l4 += lArray3[n4 + 1];
                l5 += lArray3[n4 + 2] + lArray4[n5 + 1];
                l6 += lArray3[n4 + 3] + lArray4[n5 + 2];
                l7 += lArray3[n4 + 4] + (long)i4 + 1L;
            }
            lArray2[0] = l4;
            lArray2[1] = l5;
            lArray2[2] = l6;
            lArray2[3] = l7;
        }

        void decryptBlock(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.kw;
            long[] lArray4 = this.t;
            int[] nArray = MOD5;
            int[] nArray2 = MOD3;
            if (lArray3.length != 9) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l4 = lArray[0];
            long l5 = lArray[1];
            long l6 = lArray[2];
            long l7 = lArray[3];
            for (int i4 = 17; i4 >= 1; i4 -= 2) {
                int n4 = nArray[i4];
                int n5 = nArray2[i4];
                l5 -= lArray3[n4 + 2] + lArray4[n5 + 1];
                l7 -= lArray3[n4 + 4] + (long)i4 + 1L;
                l7 = ThreefishEngine.xorRotr(l7, 32, l4 -= lArray3[n4 + 1]);
                l5 = ThreefishEngine.xorRotr(l5, 32, l6 -= lArray3[n4 + 3] + lArray4[n5 + 2]);
                l6 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 58, l4 -= l7);
                l7 = ThreefishEngine.xorRotr(l7, 22, l6);
                l6 -= l7;
                l7 = ThreefishEngine.xorRotr(l7, 46, l4 -= l5);
                l5 = ThreefishEngine.xorRotr(l5, 12, l6);
                l6 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 25, l4 -= l7);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 33, l6);
                l6 -= l7;
                l5 -= lArray3[n4 + 1] + lArray4[n5];
                l7 -= lArray3[n4 + 3] + (long)i4;
                l7 = ThreefishEngine.xorRotr(l7, 5, l4 -= lArray3[n4]);
                l5 = ThreefishEngine.xorRotr(l5, 37, l6 -= lArray3[n4 + 2] + lArray4[n5 + 1]);
                l6 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 23, l4 -= l7);
                l7 = ThreefishEngine.xorRotr(l7, 40, l6);
                l6 -= l7;
                l7 = ThreefishEngine.xorRotr(l7, 52, l4 -= l5);
                l5 = ThreefishEngine.xorRotr(l5, 57, l6);
                l6 -= l5;
                l5 = ThreefishEngine.xorRotr(l5, 14, l4 -= l7);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 16, l6);
                l6 -= l7;
            }
            lArray2[0] = l4 -= lArray3[0];
            lArray2[1] = l5 -= lArray3[1] + lArray4[0];
            lArray2[2] = l6 -= lArray3[2] + lArray4[1];
            lArray2[3] = l7 -= lArray3[3];
        }
    }

    private static final class Threefish512Cipher
    extends ThreefishCipher {
        private static final int ROTATION_0_0 = 46;
        private static final int ROTATION_0_1 = 36;
        private static final int ROTATION_0_2 = 19;
        private static final int ROTATION_0_3 = 37;
        private static final int ROTATION_1_0 = 33;
        private static final int ROTATION_1_1 = 27;
        private static final int ROTATION_1_2 = 14;
        private static final int ROTATION_1_3 = 42;
        private static final int ROTATION_2_0 = 17;
        private static final int ROTATION_2_1 = 49;
        private static final int ROTATION_2_2 = 36;
        private static final int ROTATION_2_3 = 39;
        private static final int ROTATION_3_0 = 44;
        private static final int ROTATION_3_1 = 9;
        private static final int ROTATION_3_2 = 54;
        private static final int ROTATION_3_3 = 56;
        private static final int ROTATION_4_0 = 39;
        private static final int ROTATION_4_1 = 30;
        private static final int ROTATION_4_2 = 34;
        private static final int ROTATION_4_3 = 24;
        private static final int ROTATION_5_0 = 13;
        private static final int ROTATION_5_1 = 50;
        private static final int ROTATION_5_2 = 10;
        private static final int ROTATION_5_3 = 17;
        private static final int ROTATION_6_0 = 25;
        private static final int ROTATION_6_1 = 29;
        private static final int ROTATION_6_2 = 39;
        private static final int ROTATION_6_3 = 43;
        private static final int ROTATION_7_0 = 8;
        private static final int ROTATION_7_1 = 35;
        private static final int ROTATION_7_2 = 56;
        private static final int ROTATION_7_3 = 22;

        protected Threefish512Cipher(long[] lArray, long[] lArray2) {
            super(lArray, lArray2);
        }

        public void encryptBlock(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.kw;
            long[] lArray4 = this.t;
            int[] nArray = MOD9;
            int[] nArray2 = MOD3;
            if (lArray3.length != 17) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l4 = lArray[0];
            long l5 = lArray[1];
            long l6 = lArray[2];
            long l7 = lArray[3];
            long l8 = lArray[4];
            long l9 = lArray[5];
            long l10 = lArray[6];
            long l11 = lArray[7];
            l4 += lArray3[0];
            l5 += lArray3[1];
            l6 += lArray3[2];
            l7 += lArray3[3];
            l8 += lArray3[4];
            l9 += lArray3[5] + lArray4[0];
            l10 += lArray3[6] + lArray4[1];
            l11 += lArray3[7];
            for (int i4 = 1; i4 < 18; i4 += 2) {
                int n4 = nArray[i4];
                int n5 = nArray2[i4];
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 46, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 36, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 19, l8);
                l10 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 37, l10);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 33, l6);
                l8 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 27, l8);
                l10 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 14, l10);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 42, l4);
                l8 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 17, l8);
                l10 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 49, l10);
                l4 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 36, l4);
                l6 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 39, l6);
                l10 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 44, l10);
                l4 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 9, l4);
                l6 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 54, l6);
                l8 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 56, l8);
                l4 += lArray3[n4];
                l5 += lArray3[n4 + 1];
                l6 += lArray3[n4 + 2];
                l7 += lArray3[n4 + 3];
                l8 += lArray3[n4 + 4];
                l9 += lArray3[n4 + 5] + lArray4[n5];
                l10 += lArray3[n4 + 6] + lArray4[n5 + 1];
                l11 += lArray3[n4 + 7] + (long)i4;
                l4 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 39, l4);
                l6 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 30, l6);
                l8 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 34, l8);
                l10 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 24, l10);
                l6 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 13, l6);
                l8 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 50, l8);
                l10 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 10, l10);
                l4 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 17, l4);
                l8 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 25, l8);
                l10 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 29, l10);
                l4 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 39, l4);
                l6 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 43, l6);
                l10 += l5;
                l5 = ThreefishEngine.rotlXor(l5, 8, l10);
                l4 += l11;
                l11 = ThreefishEngine.rotlXor(l11, 35, l4);
                l6 += l9;
                l9 = ThreefishEngine.rotlXor(l9, 56, l6);
                l8 += l7;
                l7 = ThreefishEngine.rotlXor(l7, 22, l8);
                l4 += lArray3[n4 + 1];
                l5 += lArray3[n4 + 2];
                l6 += lArray3[n4 + 3];
                l7 += lArray3[n4 + 4];
                l8 += lArray3[n4 + 5];
                l9 += lArray3[n4 + 6] + lArray4[n5 + 1];
                l10 += lArray3[n4 + 7] + lArray4[n5 + 2];
                l11 += lArray3[n4 + 8] + (long)i4 + 1L;
            }
            lArray2[0] = l4;
            lArray2[1] = l5;
            lArray2[2] = l6;
            lArray2[3] = l7;
            lArray2[4] = l8;
            lArray2[5] = l9;
            lArray2[6] = l10;
            lArray2[7] = l11;
        }

        public void decryptBlock(long[] lArray, long[] lArray2) {
            long[] lArray3 = this.kw;
            long[] lArray4 = this.t;
            int[] nArray = MOD9;
            int[] nArray2 = MOD3;
            if (lArray3.length != 17) {
                throw new IllegalArgumentException();
            }
            if (lArray4.length != 5) {
                throw new IllegalArgumentException();
            }
            long l4 = lArray[0];
            long l5 = lArray[1];
            long l6 = lArray[2];
            long l7 = lArray[3];
            long l8 = lArray[4];
            long l9 = lArray[5];
            long l10 = lArray[6];
            long l11 = lArray[7];
            for (int i4 = 17; i4 >= 1; i4 -= 2) {
                int n4 = nArray[i4];
                int n5 = nArray2[i4];
                l4 -= lArray3[n4 + 1];
                l5 -= lArray3[n4 + 2];
                l6 -= lArray3[n4 + 3];
                l7 -= lArray3[n4 + 4];
                l8 -= lArray3[n4 + 5];
                l9 -= lArray3[n4 + 6] + lArray4[n5 + 1];
                l11 -= lArray3[n4 + 8] + (long)i4 + 1L;
                l5 = ThreefishEngine.xorRotr(l5, 8, l10 -= lArray3[n4 + 7] + lArray4[n5 + 2]);
                l10 -= l5;
                l11 = ThreefishEngine.xorRotr(l11, 35, l4);
                l4 -= l11;
                l9 = ThreefishEngine.xorRotr(l9, 56, l6);
                l6 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 22, l8);
                l5 = ThreefishEngine.xorRotr(l5, 25, l8 -= l7);
                l8 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 29, l10);
                l10 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 39, l4);
                l4 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 43, l6);
                l5 = ThreefishEngine.xorRotr(l5, 13, l6 -= l11);
                l6 -= l5;
                l11 = ThreefishEngine.xorRotr(l11, 50, l8);
                l8 -= l11;
                l9 = ThreefishEngine.xorRotr(l9, 10, l10);
                l10 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 17, l4);
                l5 = ThreefishEngine.xorRotr(l5, 39, l4 -= l7);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 30, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 34, l8);
                l8 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 24, l10);
                l10 -= l11;
                l4 -= lArray3[n4];
                l5 -= lArray3[n4 + 1];
                l6 -= lArray3[n4 + 2];
                l7 -= lArray3[n4 + 3];
                l8 -= lArray3[n4 + 4];
                l9 -= lArray3[n4 + 5] + lArray4[n5];
                l11 -= lArray3[n4 + 7] + (long)i4;
                l5 = ThreefishEngine.xorRotr(l5, 44, l10 -= lArray3[n4 + 6] + lArray4[n5 + 1]);
                l10 -= l5;
                l11 = ThreefishEngine.xorRotr(l11, 9, l4);
                l4 -= l11;
                l9 = ThreefishEngine.xorRotr(l9, 54, l6);
                l6 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 56, l8);
                l5 = ThreefishEngine.xorRotr(l5, 17, l8 -= l7);
                l8 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 49, l10);
                l10 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 36, l4);
                l4 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 39, l6);
                l5 = ThreefishEngine.xorRotr(l5, 33, l6 -= l11);
                l6 -= l5;
                l11 = ThreefishEngine.xorRotr(l11, 27, l8);
                l8 -= l11;
                l9 = ThreefishEngine.xorRotr(l9, 14, l10);
                l10 -= l9;
                l7 = ThreefishEngine.xorRotr(l7, 42, l4);
                l5 = ThreefishEngine.xorRotr(l5, 46, l4 -= l7);
                l4 -= l5;
                l7 = ThreefishEngine.xorRotr(l7, 36, l6);
                l6 -= l7;
                l9 = ThreefishEngine.xorRotr(l9, 19, l8);
                l8 -= l9;
                l11 = ThreefishEngine.xorRotr(l11, 37, l10);
                l10 -= l11;
            }
            l4 -= lArray3[0];
            l5 -= lArray3[1];
            l6 -= lArray3[2];
            l7 -= lArray3[3];
            l8 -= lArray3[4];
            l9 -= lArray3[5] + lArray4[0];
            l10 -= lArray3[6] + lArray4[1];
            l11 -= lArray3[7];
            lArray2[0] = l4;
            lArray2[1] = l5;
            lArray2[2] = l6;
            lArray2[3] = l7;
            lArray2[4] = l8;
            lArray2[5] = l9;
            lArray2[6] = l10;
            lArray2[7] = l11;
        }
    }

    private static abstract class ThreefishCipher {
        protected final long[] t;
        protected final long[] kw;

        protected ThreefishCipher(long[] lArray, long[] lArray2) {
            this.kw = lArray;
            this.t = lArray2;
        }

        abstract void encryptBlock(long[] var1, long[] var2);

        abstract void decryptBlock(long[] var1, long[] var2);
    }
}

