/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.macs.MacCFBBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class CFBBlockCipherMac
implements Mac {
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private MacCFBBlockCipher cipher;
    private BlockCipherPadding padding = null;
    private int macSize;

    public CFBBlockCipherMac(BlockCipher blockCipher) {
        this(blockCipher, 8, blockCipher.getBlockSize() * 8 / 2, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this(blockCipher, 8, blockCipher.getBlockSize() * 8 / 2, blockCipherPadding);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n4, int n5) {
        this(blockCipher, n4, n5, null);
    }

    public CFBBlockCipherMac(BlockCipher blockCipher, int n4, int n5, BlockCipherPadding blockCipherPadding) {
        if (n5 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        this.mac = new byte[blockCipher.getBlockSize()];
        this.cipher = new MacCFBBlockCipher(blockCipher, n4);
        this.padding = blockCipherPadding;
        this.macSize = n5 / 8;
        this.buf = new byte[this.cipher.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    public void init(CipherParameters cipherParameters) {
        this.reset();
        this.cipher.init(cipherParameters);
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
    }

    public void update(byte[] byArray, int n4, int n5) {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n6 = this.cipher.getBlockSize();
        int n7 = 0;
        int n8 = n6 - this.bufOff;
        if (n5 > n8) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n8);
            n7 += this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n5 -= n8;
            n4 += n8;
            while (n5 > n6) {
                n7 += this.cipher.processBlock(byArray, n4, this.mac, 0);
                n5 -= n6;
                n4 += n6;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
    }

    public int doFinal(byte[] byArray, int n4) {
        int n5 = this.cipher.getBlockSize();
        if (this.padding == null) {
            while (this.bufOff < n5) {
                this.buf[this.bufOff] = 0;
                ++this.bufOff;
            }
        } else {
            this.padding.addPadding(this.buf, this.bufOff);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        this.cipher.getMacBlock(this.mac);
        System.arraycopy(this.mac, 0, byArray, n4, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i4 = 0; i4 < this.buf.length; ++i4) {
            this.buf[i4] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

