/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithSBox;

public class GOST28147Mac
implements Mac {
    private int blockSize = 8;
    private int macSize = 4;
    private int bufOff = 0;
    private byte[] buf;
    private byte[] mac;
    private boolean firstStep = true;
    private int[] workingKey = null;
    private byte[] S = new byte[]{9, 6, 3, 2, 8, 11, 1, 7, 10, 4, 14, 15, 12, 0, 13, 5, 3, 7, 14, 9, 8, 10, 15, 0, 5, 2, 6, 12, 11, 4, 13, 1, 14, 4, 6, 2, 11, 3, 13, 8, 12, 15, 5, 10, 0, 7, 1, 9, 14, 7, 10, 12, 13, 1, 3, 9, 0, 2, 11, 4, 15, 8, 5, 6, 11, 5, 1, 9, 8, 13, 15, 0, 14, 4, 2, 3, 12, 7, 10, 6, 3, 10, 13, 12, 1, 2, 0, 11, 7, 5, 9, 4, 8, 15, 14, 6, 1, 13, 2, 9, 7, 10, 6, 0, 8, 12, 4, 5, 15, 3, 11, 14, 11, 10, 15, 5, 0, 12, 14, 8, 6, 2, 3, 9, 1, 7, 13, 4};

    public GOST28147Mac() {
        this.mac = new byte[this.blockSize];
        this.buf = new byte[this.blockSize];
    }

    private int[] generateWorkingKey(byte[] byArray) {
        if (byArray.length != 32) {
            throw new IllegalArgumentException("Key length invalid. Key needs to be 32 byte - 256 bit!!!");
        }
        int[] nArray = new int[8];
        for (int i4 = 0; i4 != 8; ++i4) {
            nArray[i4] = this.bytesToint(byArray, i4 * 4);
        }
        return nArray;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        this.reset();
        this.buf = new byte[this.blockSize];
        if (cipherParameters instanceof ParametersWithSBox) {
            ParametersWithSBox parametersWithSBox = (ParametersWithSBox)cipherParameters;
            System.arraycopy(parametersWithSBox.getSBox(), 0, this.S, 0, parametersWithSBox.getSBox().length);
            if (parametersWithSBox.getParameters() != null) {
                this.workingKey = this.generateWorkingKey(((KeyParameter)parametersWithSBox.getParameters()).getKey());
            }
        } else if (cipherParameters instanceof KeyParameter) {
            this.workingKey = this.generateWorkingKey(((KeyParameter)cipherParameters).getKey());
        } else {
            throw new IllegalArgumentException("invalid parameter passed to GOST28147 init - " + cipherParameters.getClass().getName());
        }
    }

    public String getAlgorithmName() {
        return "GOST28147Mac";
    }

    public int getMacSize() {
        return this.macSize;
    }

    private int gost28147_mainStep(int n4, int n5) {
        int n6 = n5 + n4;
        int n7 = this.S[0 + (n6 >> 0 & 0xF)] << 0;
        n7 += this.S[16 + (n6 >> 4 & 0xF)] << 4;
        n7 += this.S[32 + (n6 >> 8 & 0xF)] << 8;
        n7 += this.S[48 + (n6 >> 12 & 0xF)] << 12;
        n7 += this.S[64 + (n6 >> 16 & 0xF)] << 16;
        n7 += this.S[80 + (n6 >> 20 & 0xF)] << 20;
        n7 += this.S[96 + (n6 >> 24 & 0xF)] << 24;
        return (n7 += this.S[112 + (n6 >> 28 & 0xF)] << 28) << 11 | n7 >>> 21;
    }

    private void gost28147MacFunc(int[] nArray, byte[] byArray, int n4, byte[] byArray2, int n5) {
        int n6 = this.bytesToint(byArray, n4);
        int n7 = this.bytesToint(byArray, n4 + 4);
        for (int i4 = 0; i4 < 2; ++i4) {
            for (int i5 = 0; i5 < 8; ++i5) {
                int n8 = n6;
                n6 = n7 ^ this.gost28147_mainStep(n6, nArray[i5]);
                n7 = n8;
            }
        }
        this.intTobytes(n6, byArray2, n5);
        this.intTobytes(n7, byArray2, n5 + 4);
    }

    private int bytesToint(byte[] byArray, int n4) {
        return (byArray[n4 + 3] << 24 & 0xFF000000) + (byArray[n4 + 2] << 16 & 0xFF0000) + (byArray[n4 + 1] << 8 & 0xFF00) + (byArray[n4] & 0xFF);
    }

    private void intTobytes(int n4, byte[] byArray, int n5) {
        byArray[n5 + 3] = (byte)(n4 >>> 24);
        byArray[n5 + 2] = (byte)(n4 >>> 16);
        byArray[n5 + 1] = (byte)(n4 >>> 8);
        byArray[n5] = (byte)n4;
    }

    private byte[] CM5func(byte[] byArray, int n4, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length - n4];
        System.arraycopy(byArray, n4, byArray3, 0, byArray2.length);
        for (int i4 = 0; i4 != byArray2.length; ++i4) {
            byArray3[i4] = (byte)(byArray3[i4] ^ byArray2[i4]);
        }
        return byArray3;
    }

    public void update(byte by) throws IllegalStateException {
        if (this.bufOff == this.buf.length) {
            byte[] byArray = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, byArray, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
            } else {
                byArray = this.CM5func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(this.workingKey, byArray, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
    }

    public void update(byte[] byArray, int n4, int n5) throws DataLengthException, IllegalStateException {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n6 = this.blockSize - this.bufOff;
        if (n5 > n6) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n6);
            byte[] byArray2 = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, byArray2, 0, this.mac.length);
            if (this.firstStep) {
                this.firstStep = false;
            } else {
                byArray2 = this.CM5func(this.buf, 0, this.mac);
            }
            this.gost28147MacFunc(this.workingKey, byArray2, 0, this.mac, 0);
            this.bufOff = 0;
            n5 -= n6;
            n4 += n6;
            while (n5 > this.blockSize) {
                byArray2 = this.CM5func(byArray, n4, this.mac);
                this.gost28147MacFunc(this.workingKey, byArray2, 0, this.mac, 0);
                n5 -= this.blockSize;
                n4 += this.blockSize;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
    }

    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        while (this.bufOff < this.blockSize) {
            this.buf[this.bufOff] = 0;
            ++this.bufOff;
        }
        byte[] byArray2 = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, byArray2, 0, this.mac.length);
        if (this.firstStep) {
            this.firstStep = false;
        } else {
            byArray2 = this.CM5func(this.buf, 0, this.mac);
        }
        this.gost28147MacFunc(this.workingKey, byArray2, 0, this.mac, 0);
        System.arraycopy(this.mac, this.mac.length / 2 - this.macSize, byArray, n4, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i4 = 0; i4 < this.buf.length; ++i4) {
            this.buf[i4] = 0;
        }
        this.bufOff = 0;
        this.firstStep = true;
    }
}

