/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.macs.CMac;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public class EAXBlockCipher
implements AEADBlockCipher {
    private static final byte nTAG = 0;
    private static final byte hTAG = 1;
    private static final byte cTAG = 2;
    private SICBlockCipher cipher;
    private boolean forEncryption;
    private int blockSize;
    private Mac mac;
    private byte[] nonceMac;
    private byte[] associatedTextMac;
    private byte[] macBlock;
    private int macSize;
    private byte[] bufBlock;
    private int bufOff;
    private boolean cipherInitialized;
    private byte[] initialAssociatedText;

    public EAXBlockCipher(BlockCipher blockCipher) {
        this.blockSize = blockCipher.getBlockSize();
        this.mac = new CMac(blockCipher);
        this.macBlock = new byte[this.blockSize];
        this.associatedTextMac = new byte[this.mac.getMacSize()];
        this.nonceMac = new byte[this.mac.getMacSize()];
        this.cipher = new SICBlockCipher(blockCipher);
    }

    public String getAlgorithmName() {
        return this.cipher.getUnderlyingCipher().getAlgorithmName() + "/EAX";
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher.getUnderlyingCipher();
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        CipherParameters cipherParameters2;
        byte[] byArray;
        Object object;
        this.forEncryption = bl;
        if (cipherParameters instanceof AEADParameters) {
            object = (AEADParameters)cipherParameters;
            byArray = ((AEADParameters)object).getNonce();
            this.initialAssociatedText = ((AEADParameters)object).getAssociatedText();
            this.macSize = ((AEADParameters)object).getMacSize() / 8;
            cipherParameters2 = ((AEADParameters)object).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            object = (ParametersWithIV)cipherParameters;
            byArray = ((ParametersWithIV)object).getIV();
            this.initialAssociatedText = null;
            this.macSize = this.mac.getMacSize() / 2;
            cipherParameters2 = ((ParametersWithIV)object).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to EAX");
        }
        this.bufBlock = new byte[bl ? this.blockSize : this.blockSize + this.macSize];
        object = new byte[this.blockSize];
        this.mac.init(cipherParameters2);
        object[this.blockSize - 1] = false;
        this.mac.update((byte[])object, 0, this.blockSize);
        this.mac.update(byArray, 0, byArray.length);
        this.mac.doFinal(this.nonceMac, 0);
        this.cipher.init(true, new ParametersWithIV(null, this.nonceMac));
        this.reset();
    }

    private void initCipher() {
        if (this.cipherInitialized) {
            return;
        }
        this.cipherInitialized = true;
        this.mac.doFinal(this.associatedTextMac, 0);
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 2;
        this.mac.update(byArray, 0, this.blockSize);
    }

    private void calculateMac() {
        byte[] byArray = new byte[this.blockSize];
        this.mac.doFinal(byArray, 0);
        for (int i4 = 0; i4 < this.macBlock.length; ++i4) {
            this.macBlock[i4] = (byte)(this.nonceMac[i4] ^ this.associatedTextMac[i4] ^ byArray[i4]);
        }
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl) {
        this.cipher.reset();
        this.mac.reset();
        this.bufOff = 0;
        Arrays.fill(this.bufBlock, (byte)0);
        if (bl) {
            Arrays.fill(this.macBlock, (byte)0);
        }
        byte[] byArray = new byte[this.blockSize];
        byArray[this.blockSize - 1] = 1;
        this.mac.update(byArray, 0, this.blockSize);
        this.cipherInitialized = false;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public void processAADByte(byte by) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.mac.update(by);
    }

    public void processAADBytes(byte[] byArray, int n4, int n5) {
        if (this.cipherInitialized) {
            throw new IllegalStateException("AAD data cannot be added after encryption/decryption processing has begun.");
        }
        this.mac.update(byArray, n4, n5);
    }

    public int processByte(byte by, byte[] byArray, int n4) throws DataLengthException {
        this.initCipher();
        return this.process(by, byArray, n4);
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException {
        this.initCipher();
        if (byArray.length < n4 + n5) {
            throw new DataLengthException("Input buffer too short");
        }
        int n7 = 0;
        for (int i4 = 0; i4 != n5; ++i4) {
            n7 += this.process(byArray[n4 + i4], byArray2, n6 + n7);
        }
        return n7;
    }

    public int doFinal(byte[] byArray, int n4) throws IllegalStateException, InvalidCipherTextException {
        this.initCipher();
        int n5 = this.bufOff;
        byte[] byArray2 = new byte[this.bufBlock.length];
        this.bufOff = 0;
        if (this.forEncryption) {
            if (byArray.length < n4 + n5 + this.macSize) {
                throw new OutputLengthException("Output buffer too short");
            }
            this.cipher.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n4, n5);
            this.mac.update(byArray2, 0, n5);
            this.calculateMac();
            System.arraycopy(this.macBlock, 0, byArray, n4 + n5, this.macSize);
            this.reset(false);
            return n5 + this.macSize;
        }
        if (n5 < this.macSize) {
            throw new InvalidCipherTextException("data too short");
        }
        if (byArray.length < n4 + n5 - this.macSize) {
            throw new OutputLengthException("Output buffer too short");
        }
        if (n5 > this.macSize) {
            this.mac.update(this.bufBlock, 0, n5 - this.macSize);
            this.cipher.processBlock(this.bufBlock, 0, byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n4, n5 - this.macSize);
        }
        this.calculateMac();
        if (!this.verifyMac(this.bufBlock, n5 - this.macSize)) {
            throw new InvalidCipherTextException("mac check in EAX failed");
        }
        this.reset(false);
        return n5 - this.macSize;
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, this.macSize);
        return byArray;
    }

    public int getUpdateOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        if (!this.forEncryption) {
            if (n5 < this.macSize) {
                return 0;
            }
            n5 -= this.macSize;
        }
        return n5 - n5 % this.blockSize;
    }

    public int getOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        if (this.forEncryption) {
            return n5 + this.macSize;
        }
        return n5 < this.macSize ? 0 : n5 - this.macSize;
    }

    private int process(byte by, byte[] byArray, int n4) {
        this.bufBlock[this.bufOff++] = by;
        if (this.bufOff == this.bufBlock.length) {
            int n5;
            if (byArray.length < n4 + this.blockSize) {
                throw new OutputLengthException("Output buffer is too short");
            }
            if (this.forEncryption) {
                n5 = this.cipher.processBlock(this.bufBlock, 0, byArray, n4);
                this.mac.update(byArray, n4, this.blockSize);
            } else {
                this.mac.update(this.bufBlock, 0, this.blockSize);
                n5 = this.cipher.processBlock(this.bufBlock, 0, byArray, n4);
            }
            this.bufOff = 0;
            if (!this.forEncryption) {
                System.arraycopy(this.bufBlock, this.blockSize, this.bufBlock, 0, this.macSize);
                this.bufOff = this.macSize;
            }
            return n5;
        }
        return 0;
    }

    private boolean verifyMac(byte[] byArray, int n4) {
        int n5 = 0;
        for (int i4 = 0; i4 < this.macSize; ++i4) {
            n5 |= this.macBlock[i4] ^ byArray[n4 + i4];
        }
        return n5 == 0;
    }
}

