/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;

public class PKCS7Padding
implements BlockCipherPadding {
    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
    }

    public String getPaddingName() {
        return "PKCS7";
    }

    public int addPadding(byte[] byArray, int n4) {
        byte by = (byte)(byArray.length - n4);
        while (n4 < byArray.length) {
            byArray[n4] = by;
            ++n4;
        }
        return by;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n4 = byArray[byArray.length - 1] & 0xFF;
        byte by = (byte)n4;
        boolean bl = n4 > byArray.length | n4 == 0;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            bl |= byArray.length - i4 <= n4 & byArray[i4] != by;
        }
        if (bl) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n4;
    }
}

