/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.paddings;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class PaddedBufferedBlockCipher
extends BufferedBlockCipher {
    BlockCipherPadding padding;

    public PaddedBufferedBlockCipher(BlockCipher blockCipher, BlockCipherPadding blockCipherPadding) {
        this.cipher = blockCipher;
        this.padding = blockCipherPadding;
        this.buf = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
    }

    public PaddedBufferedBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, new PKCS7Padding());
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.padding.init(parametersWithRandom.getRandom());
            this.cipher.init(bl, parametersWithRandom.getParameters());
        } else {
            this.padding.init(null);
            this.cipher.init(bl, cipherParameters);
        }
    }

    public int getOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        int n6 = n5 % this.buf.length;
        if (n6 == 0) {
            if (this.forEncryption) {
                return n5 + this.buf.length;
            }
            return n5;
        }
        return n5 - n6 + this.buf.length;
    }

    public int getUpdateOutputSize(int n4) {
        int n5 = n4 + this.bufOff;
        int n6 = n5 % this.buf.length;
        if (n6 == 0) {
            return Math.max(0, n5 - this.buf.length);
        }
        return n5 - n6;
    }

    public int processByte(byte by, byte[] byArray, int n4) throws DataLengthException, IllegalStateException {
        int n5 = 0;
        if (this.bufOff == this.buf.length) {
            n5 = this.cipher.processBlock(this.buf, 0, byArray, n4);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by;
        return n5;
    }

    public int processBytes(byte[] byArray, int n4, int n5, byte[] byArray2, int n6) throws DataLengthException, IllegalStateException {
        if (n5 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n7 = this.getBlockSize();
        int n8 = this.getUpdateOutputSize(n5);
        if (n8 > 0 && n6 + n8 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n9 = 0;
        int n10 = this.buf.length - this.bufOff;
        if (n5 > n10) {
            System.arraycopy(byArray, n4, this.buf, this.bufOff, n10);
            n9 += this.cipher.processBlock(this.buf, 0, byArray2, n6);
            this.bufOff = 0;
            n5 -= n10;
            n4 += n10;
            while (n5 > this.buf.length) {
                n9 += this.cipher.processBlock(byArray, n4, byArray2, n6 + n9);
                n5 -= n7;
                n4 += n7;
            }
        }
        System.arraycopy(byArray, n4, this.buf, this.bufOff, n5);
        this.bufOff += n5;
        return n9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doFinal(byte[] byArray, int n4) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        int n5 = this.cipher.getBlockSize();
        int n6 = 0;
        if (this.forEncryption) {
            if (this.bufOff == n5) {
                if (n4 + 2 * n5 > byArray.length) {
                    this.reset();
                    throw new OutputLengthException("output buffer too short");
                }
                n6 = this.cipher.processBlock(this.buf, 0, byArray, n4);
                this.bufOff = 0;
            }
            this.padding.addPadding(this.buf, this.bufOff);
            n6 += this.cipher.processBlock(this.buf, 0, byArray, n4 + n6);
            this.reset();
        } else {
            if (this.bufOff != n5) {
                this.reset();
                throw new DataLengthException("last block incomplete in decryption");
            }
            n6 = this.cipher.processBlock(this.buf, 0, this.buf, 0);
            this.bufOff = 0;
            try {
                System.arraycopy(this.buf, 0, byArray, n4, n6 -= this.padding.padCount(this.buf));
            }
            finally {
                this.reset();
            }
        }
        return n6;
    }
}

