/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.InputStream;
import org.bouncycastle.crypto.tls.ByteQueue;

public class ByteQueueInputStream
extends InputStream {
    private ByteQueue buffer = new ByteQueue();

    public void addBytes(byte[] byArray) {
        this.buffer.addData(byArray, 0, byArray.length);
    }

    public int peek(byte[] byArray) {
        int n4 = Math.min(this.buffer.available(), byArray.length);
        this.buffer.read(byArray, 0, n4, 0);
        return n4;
    }

    public int read() {
        if (this.buffer.available() == 0) {
            return -1;
        }
        return this.buffer.removeData(1, 0)[0] & 0xFF;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n4, int n5) {
        int n6 = Math.min(this.buffer.available(), n5);
        this.buffer.removeData(byArray, n4, n6, 0);
        return n6;
    }

    public long skip(long l4) {
        int n4 = Math.min((int)l4, this.buffer.available());
        this.buffer.removeData(n4);
        return n4;
    }

    public int available() {
        return this.buffer.available();
    }

    public void close() {
    }
}

