/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.crypto.tls.HeartbeatMessageType;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class HeartbeatMessage {
    protected short type;
    protected byte[] payload;
    protected int paddingLength;

    public HeartbeatMessage(short s4, byte[] byArray, int n4) {
        if (!HeartbeatMessageType.isValid(s4)) {
            throw new IllegalArgumentException("'type' is not a valid HeartbeatMessageType value");
        }
        if (byArray == null || byArray.length >= 65536) {
            throw new IllegalArgumentException("'payload' must have length < 2^16");
        }
        if (n4 < 16) {
            throw new IllegalArgumentException("'paddingLength' must be at least 16");
        }
        this.type = s4;
        this.payload = byArray;
        this.paddingLength = n4;
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8(this.type, outputStream);
        TlsUtils.checkUint16(this.payload.length);
        TlsUtils.writeUint16(this.payload.length, outputStream);
        outputStream.write(this.payload);
        byte[] byArray = new byte[this.paddingLength];
        tlsContext.getNonceRandomGenerator().nextBytes(byArray);
        outputStream.write(byArray);
    }

    public static HeartbeatMessage parse(InputStream inputStream) throws IOException {
        short s4 = TlsUtils.readUint8(inputStream);
        if (!HeartbeatMessageType.isValid(s4)) {
            throw new TlsFatalAlert(47);
        }
        int n4 = TlsUtils.readUint16(inputStream);
        PayloadBuffer payloadBuffer = new PayloadBuffer();
        Streams.pipeAll(inputStream, payloadBuffer);
        byte[] byArray = payloadBuffer.toTruncatedByteArray(n4);
        if (byArray == null) {
            return null;
        }
        int n5 = payloadBuffer.size() - byArray.length;
        return new HeartbeatMessage(s4, byArray, n5);
    }

    static class PayloadBuffer
    extends ByteArrayOutputStream {
        PayloadBuffer() {
        }

        byte[] toTruncatedByteArray(int n4) {
            int n5 = n4 + 16;
            if (this.count < n5) {
                return null;
            }
            return Arrays.copyOf(this.buf, n4);
        }
    }
}

