/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.ECPointMap;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.WNafPreCompInfo;

public abstract class WNafUtil {
    public static final String PRECOMP_NAME = "bc_wnaf";
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final ECPoint[] EMPTY_POINTS = new ECPoint[0];

    public static int[] generateCompactNaf(BigInteger bigInteger) {
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_INTS;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n4 = bigInteger2.bitLength();
        int[] nArray = new int[n4 >> 1];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        int n5 = n4 - 1;
        int n6 = 0;
        int n7 = 0;
        for (int i4 = 1; i4 < n5; ++i4) {
            if (!bigInteger3.testBit(i4)) {
                ++n7;
                continue;
            }
            int n8 = bigInteger.testBit(i4) ? -1 : 1;
            nArray[n6++] = n8 << 16 | n7;
            n7 = 1;
            ++i4;
        }
        nArray[n6++] = 0x10000 | n7;
        if (nArray.length > n6) {
            nArray = WNafUtil.trim(nArray, n6);
        }
        return nArray;
    }

    public static int[] generateCompactWindowNaf(int n4, BigInteger bigInteger) {
        if (n4 == 2) {
            return WNafUtil.generateCompactNaf(bigInteger);
        }
        if (n4 < 2 || n4 > 16) {
            throw new IllegalArgumentException("'width' must be in the range [2, 16]");
        }
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_INTS;
        }
        int[] nArray = new int[bigInteger.bitLength() / n4 + 1];
        int n5 = 1 << n4;
        int n6 = n5 - 1;
        int n7 = n5 >>> 1;
        boolean bl = false;
        int n8 = 0;
        int n9 = 0;
        while (n9 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n9) == bl) {
                ++n9;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n9);
            int n10 = bigInteger.intValue() & n6;
            if (bl) {
                ++n10;
            }
            boolean bl2 = bl = (n10 & n7) != 0;
            if (bl) {
                n10 -= n5;
            }
            int n11 = n8 > 0 ? n9 - 1 : n9;
            nArray[n8++] = n10 << 16 | n11;
            n9 = n4;
        }
        if (nArray.length > n8) {
            nArray = WNafUtil.trim(nArray, n8);
        }
        return nArray;
    }

    public static byte[] generateJSF(BigInteger bigInteger, BigInteger bigInteger2) {
        int n4 = Math.max(bigInteger.bitLength(), bigInteger2.bitLength()) + 1;
        byte[] byArray = new byte[n4];
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n6 | n7 || bigInteger3.bitLength() > n8 || bigInteger4.bitLength() > n8) {
            int n9;
            int n10 = (bigInteger3.intValue() >>> n8) + n6 & 7;
            int n11 = (bigInteger4.intValue() >>> n8) + n7 & 7;
            int n12 = n10 & 1;
            if (n12 != 0 && n10 + (n12 -= n10 & 2) == 4 && (n11 & 3) == 2) {
                n12 = -n12;
            }
            if ((n9 = n11 & 1) != 0 && n11 + (n9 -= n11 & 2) == 4 && (n10 & 3) == 2) {
                n9 = -n9;
            }
            if (n6 << 1 == 1 + n12) {
                n6 ^= 1;
            }
            if (n7 << 1 == 1 + n9) {
                n7 ^= 1;
            }
            if (++n8 == 30) {
                n8 = 0;
                bigInteger3 = bigInteger3.shiftRight(30);
                bigInteger4 = bigInteger4.shiftRight(30);
            }
            byArray[n5++] = (byte)(n12 << 4 | n9 & 0xF);
        }
        if (byArray.length > n5) {
            byArray = WNafUtil.trim(byArray, n5);
        }
        return byArray;
    }

    public static byte[] generateNaf(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n4 = bigInteger2.bitLength() - 1;
        byte[] byArray = new byte[n4];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        for (int i4 = 1; i4 < n4; ++i4) {
            if (!bigInteger3.testBit(i4)) continue;
            byArray[i4 - 1] = (byte)(bigInteger.testBit(i4) ? -1 : 1);
            ++i4;
        }
        byArray[n4 - 1] = 1;
        return byArray;
    }

    public static byte[] generateWindowNaf(int n4, BigInteger bigInteger) {
        if (n4 == 2) {
            return WNafUtil.generateNaf(bigInteger);
        }
        if (n4 < 2 || n4 > 8) {
            throw new IllegalArgumentException("'width' must be in the range [2, 8]");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[bigInteger.bitLength() + 1];
        int n5 = 1 << n4;
        int n6 = n5 - 1;
        int n7 = n5 >>> 1;
        boolean bl = false;
        int n8 = 0;
        int n9 = 0;
        while (n9 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n9) == bl) {
                ++n9;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n9);
            int n10 = bigInteger.intValue() & n6;
            if (bl) {
                ++n10;
            }
            boolean bl2 = bl = (n10 & n7) != 0;
            if (bl) {
                n10 -= n5;
            }
            n8 += n8 > 0 ? n9 - 1 : n9;
            byArray[n8++] = (byte)n10;
            n9 = n4;
        }
        if (byArray.length > n8) {
            byArray = WNafUtil.trim(byArray, n8);
        }
        return byArray;
    }

    public static int getNafWeight(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return 0;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        return bigInteger3.bitCount();
    }

    public static WNafPreCompInfo getWNafPreCompInfo(ECPoint eCPoint) {
        return WNafUtil.getWNafPreCompInfo(eCPoint.getCurve().getPreCompInfo(eCPoint, PRECOMP_NAME));
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof WNafPreCompInfo) {
            return (WNafPreCompInfo)preCompInfo;
        }
        return new WNafPreCompInfo();
    }

    public static int getWindowSize(int n4) {
        return WNafUtil.getWindowSize(n4, DEFAULT_WINDOW_SIZE_CUTOFFS);
    }

    public static int getWindowSize(int n4, int[] nArray) {
        int n5;
        for (n5 = 0; n5 < nArray.length && n4 >= nArray[n5]; ++n5) {
        }
        return n5 + 2;
    }

    public static ECPoint mapPointWithPrecomp(ECPoint eCPoint, int n4, boolean bl, ECPointMap eCPointMap) {
        Object object;
        ECCurve eCCurve = eCPoint.getCurve();
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n4, bl);
        ECPoint eCPoint2 = eCPointMap.map(eCPoint);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.getWNafPreCompInfo(eCCurve.getPreCompInfo(eCPoint2, PRECOMP_NAME));
        ECPoint eCPoint3 = wNafPreCompInfo.getTwice();
        if (eCPoint3 != null) {
            object = eCPointMap.map(eCPoint3);
            wNafPreCompInfo2.setTwice((ECPoint)object);
        }
        object = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray = new ECPoint[((ECPoint[])object).length];
        for (int i4 = 0; i4 < ((ECPoint[])object).length; ++i4) {
            eCPointArray[i4] = eCPointMap.map(object[i4]);
        }
        wNafPreCompInfo2.setPreComp(eCPointArray);
        if (bl) {
            ECPoint[] eCPointArray2 = new ECPoint[eCPointArray.length];
            for (int i5 = 0; i5 < eCPointArray2.length; ++i5) {
                eCPointArray2[i5] = eCPointArray[i5].negate();
            }
            wNafPreCompInfo2.setPreCompNeg(eCPointArray2);
        }
        eCCurve.setPreCompInfo(eCPoint2, PRECOMP_NAME, wNafPreCompInfo2);
        return eCPoint2;
    }

    public static WNafPreCompInfo precompute(ECPoint eCPoint, int n4, boolean bl) {
        ECCurve eCCurve = eCPoint.getCurve();
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.getWNafPreCompInfo(eCCurve.getPreCompInfo(eCPoint, PRECOMP_NAME));
        int n5 = 0;
        int n6 = 1 << Math.max(0, n4 - 2);
        ECPoint[] eCPointArray = wNafPreCompInfo.getPreComp();
        if (eCPointArray == null) {
            eCPointArray = EMPTY_POINTS;
        } else {
            n5 = eCPointArray.length;
        }
        if (n5 < n6) {
            eCPointArray = WNafUtil.resizeTable(eCPointArray, n6);
            if (n6 == 1) {
                eCPointArray[0] = eCPoint.normalize();
            } else {
                int n7 = n5;
                if (n7 == 0) {
                    eCPointArray[0] = eCPoint;
                    n7 = 1;
                }
                ECFieldElement eCFieldElement = null;
                if (n6 == 2) {
                    eCPointArray[1] = eCPoint.threeTimes();
                } else {
                    ECPoint eCPoint2 = wNafPreCompInfo.getTwice();
                    ECPoint eCPoint3 = eCPointArray[n7 - 1];
                    if (eCPoint2 == null) {
                        eCPoint2 = eCPointArray[0].twice();
                        wNafPreCompInfo.setTwice(eCPoint2);
                        if (!eCPoint2.isInfinity() && ECAlgorithms.isFpCurve(eCCurve) && eCCurve.getFieldSize() >= 64) {
                            switch (eCCurve.getCoordinateSystem()) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    eCFieldElement = eCPoint2.getZCoord(0);
                                    eCPoint2 = eCCurve.createPoint(eCPoint2.getXCoord().toBigInteger(), eCPoint2.getYCoord().toBigInteger());
                                    ECFieldElement eCFieldElement2 = eCFieldElement.square();
                                    ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                                    eCPoint3 = eCPoint3.scaleX(eCFieldElement2).scaleY(eCFieldElement3);
                                    if (n5 != 0) break;
                                    eCPointArray[0] = eCPoint3;
                                    break;
                                }
                            }
                        }
                    }
                    while (n7 < n6) {
                        eCPointArray[n7++] = eCPoint3 = eCPoint3.add(eCPoint2);
                    }
                }
                eCCurve.normalizeAll(eCPointArray, n5, n6 - n5, eCFieldElement);
            }
        }
        wNafPreCompInfo.setPreComp(eCPointArray);
        if (bl) {
            int n8;
            ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreCompNeg();
            if (eCPointArray2 == null) {
                n8 = 0;
                eCPointArray2 = new ECPoint[n6];
            } else {
                n8 = eCPointArray2.length;
                if (n8 < n6) {
                    eCPointArray2 = WNafUtil.resizeTable(eCPointArray2, n6);
                }
            }
            while (n8 < n6) {
                eCPointArray2[n8] = eCPointArray[n8].negate();
                ++n8;
            }
            wNafPreCompInfo.setPreCompNeg(eCPointArray2);
        }
        eCCurve.setPreCompInfo(eCPoint, PRECOMP_NAME, wNafPreCompInfo);
        return wNafPreCompInfo;
    }

    private static byte[] trim(byte[] byArray, int n4) {
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static int[] trim(int[] nArray, int n4) {
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static ECPoint[] resizeTable(ECPoint[] eCPointArray, int n4) {
        ECPoint[] eCPointArray2 = new ECPoint[n4];
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, eCPointArray.length);
        return eCPointArray2;
    }
}

