/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat128;

public class SecT113Field {
    private static final long M49 = 0x1FFFFFFFFFFFFL;
    private static final long M57 = 0x1FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat128.fromBigInteger64(bigInteger);
        SecT113Field.reduce15(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat128.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat128.create64();
        long[] lArray4 = Nat128.create64();
        SecT113Field.square(lArray, lArray3);
        SecT113Field.multiply(lArray3, lArray, lArray3);
        SecT113Field.square(lArray3, lArray3);
        SecT113Field.multiply(lArray3, lArray, lArray3);
        SecT113Field.squareN(lArray3, 3, lArray4);
        SecT113Field.multiply(lArray4, lArray3, lArray4);
        SecT113Field.square(lArray4, lArray4);
        SecT113Field.multiply(lArray4, lArray, lArray4);
        SecT113Field.squareN(lArray4, 7, lArray3);
        SecT113Field.multiply(lArray3, lArray4, lArray3);
        SecT113Field.squareN(lArray3, 14, lArray4);
        SecT113Field.multiply(lArray4, lArray3, lArray4);
        SecT113Field.squareN(lArray4, 28, lArray3);
        SecT113Field.multiply(lArray3, lArray4, lArray3);
        SecT113Field.squareN(lArray3, 56, lArray4);
        SecT113Field.multiply(lArray4, lArray3, lArray4);
        SecT113Field.square(lArray4, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat128.createExt64();
        SecT113Field.implMultiply(lArray, lArray2, lArray4);
        SecT113Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat128.createExt64();
        SecT113Field.implMultiply(lArray, lArray2, lArray4);
        SecT113Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        l5 ^= l7 << 15 ^ l7 << 24;
        long l8 = (l5 ^= l6 >>> 49 ^ l6 >>> 40) >>> 49;
        lArray2[0] = (l4 ^= (l6 ^= l7 >>> 49 ^ l7 >>> 40) << 15 ^ l6 << 24) ^ l8 ^ l8 << 9;
        lArray2[1] = l5 & 0x1FFFFFFFFFFFFL;
    }

    public static void reduce15(long[] lArray, int n4) {
        long l4 = lArray[n4 + 1];
        long l5 = l4 >>> 49;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ (l5 ^ l5 << 9);
        lArray[n4 + 1] = l4 & 0x1FFFFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l7 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        lArray2[0] = l6 ^ l7 << 57 ^ l7 << 5;
        lArray2[1] = l7 >>> 7 ^ l7 >>> 59;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat128.createExt64();
        SecT113Field.implSquare(lArray, lArray3);
        SecT113Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat128.createExt64();
        SecT113Field.implSquare(lArray, lArray3);
        SecT113Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat128.createExt64();
        SecT113Field.implSquare(lArray, lArray3);
        SecT113Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT113Field.implSquare(lArray2, lArray3);
            SecT113Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        l5 = (l4 >>> 57 ^ l5 << 7) & 0x1FFFFFFFFFFFFFFL;
        long l6 = lArray2[0];
        long l7 = lArray2[1];
        l7 = (l6 >>> 57 ^ l7 << 7) & 0x1FFFFFFFFFFFFFFL;
        long[] lArray4 = new long[6];
        SecT113Field.implMulw(l4 &= 0x1FFFFFFFFFFFFFFL, l6 &= 0x1FFFFFFFFFFFFFFL, lArray4, 0);
        SecT113Field.implMulw(l5, l7, lArray4, 2);
        SecT113Field.implMulw(l4 ^ l5, l6 ^ l7, lArray4, 4);
        long l8 = lArray4[1] ^ lArray4[2];
        long l9 = lArray4[0];
        long l10 = lArray4[3];
        long l11 = lArray4[4] ^ l9 ^ l8;
        long l12 = lArray4[5] ^ l10 ^ l8;
        lArray3[0] = l9 ^ l11 << 57;
        lArray3[1] = l11 >>> 7 ^ l12 << 50;
        lArray3[2] = l12 >>> 14 ^ l10 << 43;
        lArray3[3] = l10 >>> 21;
    }

    protected static void implMulw(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 7];
        int n6 = 48;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3 ^ lArray2[n5 >>> 6 & 7] << 6;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 9) > 0);
        lArray[n4] = l7 & 0x1FFFFFFFFFFFFFFL;
        lArray[n4 + 1] = l7 >>> 57 ^ (l6 ^= (l4 & 0x100804020100800L & l5 << 7 >> 63) >>> 8) << 7;
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
    }
}

