/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat256;

public class SecT239Field {
    private static final long M47 = 0x7FFFFFFFFFFFL;
    private static final long M60 = 0xFFFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
        lArray3[6] = lArray[6] ^ lArray2[6];
        lArray3[7] = lArray[7] ^ lArray2[7];
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat256.fromBigInteger64(bigInteger);
        SecT239Field.reduce17(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat256.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat256.create64();
        long[] lArray4 = Nat256.create64();
        SecT239Field.square(lArray, lArray3);
        SecT239Field.multiply(lArray3, lArray, lArray3);
        SecT239Field.square(lArray3, lArray3);
        SecT239Field.multiply(lArray3, lArray, lArray3);
        SecT239Field.squareN(lArray3, 3, lArray4);
        SecT239Field.multiply(lArray4, lArray3, lArray4);
        SecT239Field.square(lArray4, lArray4);
        SecT239Field.multiply(lArray4, lArray, lArray4);
        SecT239Field.squareN(lArray4, 7, lArray3);
        SecT239Field.multiply(lArray3, lArray4, lArray3);
        SecT239Field.squareN(lArray3, 14, lArray4);
        SecT239Field.multiply(lArray4, lArray3, lArray4);
        SecT239Field.square(lArray4, lArray4);
        SecT239Field.multiply(lArray4, lArray, lArray4);
        SecT239Field.squareN(lArray4, 29, lArray3);
        SecT239Field.multiply(lArray3, lArray4, lArray3);
        SecT239Field.square(lArray3, lArray3);
        SecT239Field.multiply(lArray3, lArray, lArray3);
        SecT239Field.squareN(lArray3, 59, lArray4);
        SecT239Field.multiply(lArray4, lArray3, lArray4);
        SecT239Field.square(lArray4, lArray4);
        SecT239Field.multiply(lArray4, lArray, lArray4);
        SecT239Field.squareN(lArray4, 119, lArray3);
        SecT239Field.multiply(lArray3, lArray4, lArray3);
        SecT239Field.square(lArray3, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT239Field.implMultiply(lArray, lArray2, lArray4);
        SecT239Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat256.createExt64();
        SecT239Field.implMultiply(lArray, lArray2, lArray4);
        SecT239Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        l7 ^= l11 << 17;
        l8 ^= l11 >>> 47;
        l9 ^= l11 << 47;
        l6 ^= (l10 ^= l11 >>> 17) << 17;
        l7 ^= l10 >>> 47;
        l8 ^= l10 << 47;
        l5 ^= (l9 ^= l10 >>> 17) << 17;
        l6 ^= l9 >>> 47;
        l7 ^= l9 << 47;
        long l12 = (l7 ^= l8 >>> 17) >>> 47;
        lArray2[0] = (l4 ^= (l8 ^= l9 >>> 17) << 17) ^ l12;
        lArray2[1] = l5 ^= l8 >>> 47;
        lArray2[2] = (l6 ^= l8 << 47) ^ l12 << 30;
        lArray2[3] = l7 & 0x7FFFFFFFFFFFL;
    }

    public static void reduce17(long[] lArray, int n4) {
        long l4 = lArray[n4 + 3];
        long l5 = l4 >>> 47;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ l5;
        int n6 = n4 + 2;
        lArray[n6] = lArray[n6] ^ l5 << 30;
        lArray[n4 + 3] = l4 & 0x7FFFFFFFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l7 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        l5 = Interleave.unshuffle(lArray[3]);
        long l8 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l9 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        long l10 = l9 >>> 49;
        long l11 = l7 >>> 49 | l9 << 15;
        l9 ^= l7 << 15;
        long[] lArray3 = Nat256.createExt64();
        int[] nArray = new int[]{39, 120};
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            int n4 = nArray[i4] >>> 6;
            int n5 = nArray[i4] & 0x3F;
            int n6 = n4;
            lArray3[n6] = lArray3[n6] ^ l7 << n5;
            int n7 = n4 + 1;
            lArray3[n7] = lArray3[n7] ^ (l9 << n5 | l7 >>> -n5);
            int n8 = n4 + 2;
            lArray3[n8] = lArray3[n8] ^ (l11 << n5 | l9 >>> -n5);
            int n9 = n4 + 3;
            lArray3[n9] = lArray3[n9] ^ (l10 << n5 | l11 >>> -n5);
            int n10 = n4 + 4;
            lArray3[n10] = lArray3[n10] ^ l10 >>> -n5;
        }
        SecT239Field.reduce(lArray3, lArray2);
        lArray2[0] = lArray2[0] ^ l6;
        lArray2[1] = lArray2[1] ^ l8;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT239Field.implSquare(lArray, lArray3);
        SecT239Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT239Field.implSquare(lArray, lArray3);
        SecT239Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat256.createExt64();
        SecT239Field.implSquare(lArray, lArray3);
        SecT239Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT239Field.implSquare(lArray2, lArray3);
            SecT239Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)(lArray[0] ^ lArray[1] >>> 17 ^ lArray[2] >>> 34) & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        lArray[0] = l4 ^ l5 << 60;
        lArray[1] = l5 >>> 4 ^ l6 << 56;
        lArray[2] = l6 >>> 8 ^ l7 << 52;
        lArray[3] = l7 >>> 12 ^ l8 << 48;
        lArray[4] = l8 >>> 16 ^ l9 << 44;
        lArray[5] = l9 >>> 20 ^ l10 << 40;
        lArray[6] = l10 >>> 24 ^ l11 << 36;
        lArray[7] = l11 >>> 28;
    }

    protected static void implExpand(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        lArray2[0] = l4 & 0xFFFFFFFFFFFFFFFL;
        lArray2[1] = (l4 >>> 60 ^ l5 << 4) & 0xFFFFFFFFFFFFFFFL;
        lArray2[2] = (l5 >>> 56 ^ l6 << 8) & 0xFFFFFFFFFFFFFFFL;
        lArray2[3] = l6 >>> 52 ^ l7 << 12;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        int n4;
        long[] lArray4 = new long[4];
        long[] lArray5 = new long[4];
        SecT239Field.implExpand(lArray, lArray4);
        SecT239Field.implExpand(lArray2, lArray5);
        SecT239Field.implMulwAcc(lArray4[0], lArray5[0], lArray3, 0);
        SecT239Field.implMulwAcc(lArray4[1], lArray5[1], lArray3, 1);
        SecT239Field.implMulwAcc(lArray4[2], lArray5[2], lArray3, 2);
        SecT239Field.implMulwAcc(lArray4[3], lArray5[3], lArray3, 3);
        for (n4 = 5; n4 > 0; --n4) {
            int n5 = n4;
            lArray3[n5] = lArray3[n5] ^ lArray3[n4 - 1];
        }
        SecT239Field.implMulwAcc(lArray4[0] ^ lArray4[1], lArray5[0] ^ lArray5[1], lArray3, 1);
        SecT239Field.implMulwAcc(lArray4[2] ^ lArray4[3], lArray5[2] ^ lArray5[3], lArray3, 3);
        for (n4 = 7; n4 > 1; --n4) {
            int n6 = n4;
            lArray3[n6] = lArray3[n6] ^ lArray3[n4 - 2];
        }
        long l4 = lArray4[0] ^ lArray4[2];
        long l5 = lArray4[1] ^ lArray4[3];
        long l6 = lArray5[0] ^ lArray5[2];
        long l7 = lArray5[1] ^ lArray5[3];
        SecT239Field.implMulwAcc(l4 ^ l5, l6 ^ l7, lArray3, 3);
        long[] lArray6 = new long[3];
        SecT239Field.implMulwAcc(l4, l6, lArray6, 0);
        SecT239Field.implMulwAcc(l5, l7, lArray6, 1);
        long l8 = lArray6[0];
        long l9 = lArray6[1];
        long l10 = lArray6[2];
        lArray3[2] = lArray3[2] ^ l8;
        lArray3[3] = lArray3[3] ^ (l8 ^ l9);
        lArray3[4] = lArray3[4] ^ (l10 ^ l9);
        lArray3[5] = lArray3[5] ^ l10;
        SecT239Field.implCompactExt(lArray3);
    }

    protected static void implMulwAcc(long l4, long l5, long[] lArray, int n4) {
        long[] lArray2 = new long[8];
        lArray2[1] = l5;
        lArray2[2] = lArray2[1] << 1;
        lArray2[3] = lArray2[2] ^ l5;
        lArray2[4] = lArray2[2] << 1;
        lArray2[5] = lArray2[4] ^ l5;
        lArray2[6] = lArray2[3] << 1;
        lArray2[7] = lArray2[6] ^ l5;
        int n5 = (int)l4;
        long l6 = 0L;
        long l7 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3;
        int n6 = 54;
        do {
            n5 = (int)(l4 >>> n6);
            long l8 = lArray2[n5 & 7] ^ lArray2[n5 >>> 3 & 7] << 3;
            l7 ^= l8 << n6;
            l6 ^= l8 >>> -n6;
        } while ((n6 -= 6) > 0);
        int n7 = n4;
        lArray[n7] = lArray[n7] ^ l7 & 0xFFFFFFFFFFFFFFFL;
        int n8 = n4 + 1;
        lArray[n8] = lArray[n8] ^ (l7 >>> 60 ^ (l6 ^= (l4 & 0x820820820820820L & l5 << 4 >> 63) >>> 5) << 4);
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        Interleave.expand64To128(lArray[0], lArray2, 0);
        Interleave.expand64To128(lArray[1], lArray2, 2);
        Interleave.expand64To128(lArray[2], lArray2, 4);
        long l4 = lArray[3];
        lArray2[6] = Interleave.expand32to64((int)l4);
        lArray2[7] = (long)Interleave.expand16to32((int)(l4 >>> 32)) & 0xFFFFFFFFL;
    }
}

