/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle.math.raw.Interleave;
import org.bouncycastle.math.raw.Nat;
import org.bouncycastle.math.raw.Nat448;

public class SecT409Field {
    private static final long M25 = 0x1FFFFFFL;
    private static final long M59 = 0x7FFFFFFFFFFFFFFL;

    public static void add(long[] lArray, long[] lArray2, long[] lArray3) {
        lArray3[0] = lArray[0] ^ lArray2[0];
        lArray3[1] = lArray[1] ^ lArray2[1];
        lArray3[2] = lArray[2] ^ lArray2[2];
        lArray3[3] = lArray[3] ^ lArray2[3];
        lArray3[4] = lArray[4] ^ lArray2[4];
        lArray3[5] = lArray[5] ^ lArray2[5];
        lArray3[6] = lArray[6] ^ lArray2[6];
    }

    public static void addExt(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i4 = 0; i4 < 13; ++i4) {
            lArray3[i4] = lArray[i4] ^ lArray2[i4];
        }
    }

    public static void addOne(long[] lArray, long[] lArray2) {
        lArray2[0] = lArray[0] ^ 1L;
        lArray2[1] = lArray[1];
        lArray2[2] = lArray[2];
        lArray2[3] = lArray[3];
        lArray2[4] = lArray[4];
        lArray2[5] = lArray[5];
        lArray2[6] = lArray[6];
    }

    public static long[] fromBigInteger(BigInteger bigInteger) {
        long[] lArray = Nat448.fromBigInteger64(bigInteger);
        SecT409Field.reduce39(lArray, 0);
        return lArray;
    }

    public static void invert(long[] lArray, long[] lArray2) {
        if (Nat448.isZero64(lArray)) {
            throw new IllegalStateException();
        }
        long[] lArray3 = Nat448.create64();
        long[] lArray4 = Nat448.create64();
        long[] lArray5 = Nat448.create64();
        SecT409Field.square(lArray, lArray3);
        SecT409Field.squareN(lArray3, 1, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray4, 1, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray3, 3, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray3, 6, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray3, 12, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray5);
        SecT409Field.squareN(lArray5, 24, lArray3);
        SecT409Field.squareN(lArray3, 24, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray3, 48, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray3, 96, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.squareN(lArray3, 192, lArray4);
        SecT409Field.multiply(lArray3, lArray4, lArray3);
        SecT409Field.multiply(lArray3, lArray5, lArray2);
    }

    public static void multiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat448.createExt64();
        SecT409Field.implMultiply(lArray, lArray2, lArray4);
        SecT409Field.reduce(lArray4, lArray3);
    }

    public static void multiplyAddToExt(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = Nat448.createExt64();
        SecT409Field.implMultiply(lArray, lArray2, lArray4);
        SecT409Field.addExt(lArray3, lArray4, lArray3);
    }

    public static void reduce(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        long l12 = lArray[12];
        l9 ^= l12 << 39;
        l10 ^= l12 >>> 25 ^ l12 << 62;
        l11 ^= l12 >>> 2;
        l12 = lArray[11];
        l8 ^= l12 << 39;
        l9 ^= l12 >>> 25 ^ l12 << 62;
        l10 ^= l12 >>> 2;
        l12 = lArray[10];
        l7 ^= l12 << 39;
        l8 ^= l12 >>> 25 ^ l12 << 62;
        l9 ^= l12 >>> 2;
        l12 = lArray[9];
        l6 ^= l12 << 39;
        l7 ^= l12 >>> 25 ^ l12 << 62;
        l8 ^= l12 >>> 2;
        l12 = lArray[8];
        l5 ^= l12 << 39;
        l6 ^= l12 >>> 25 ^ l12 << 62;
        l7 ^= l12 >>> 2;
        l12 = l11;
        long l13 = l10 >>> 25;
        lArray2[0] = (l4 ^= l12 << 39) ^ l13;
        lArray2[1] = (l5 ^= l12 >>> 25 ^ l12 << 62) ^ l13 << 23;
        lArray2[2] = l6 ^= l12 >>> 2;
        lArray2[3] = l7;
        lArray2[4] = l8;
        lArray2[5] = l9;
        lArray2[6] = l10 & 0x1FFFFFFL;
    }

    public static void reduce39(long[] lArray, int n4) {
        long l4 = lArray[n4 + 6];
        long l5 = l4 >>> 25;
        int n5 = n4;
        lArray[n5] = lArray[n5] ^ l5;
        int n6 = n4 + 1;
        lArray[n6] = lArray[n6] ^ l5 << 23;
        lArray[n4 + 6] = l4 & 0x1FFFFFFL;
    }

    public static void sqrt(long[] lArray, long[] lArray2) {
        long l4 = Interleave.unshuffle(lArray[0]);
        long l5 = Interleave.unshuffle(lArray[1]);
        long l6 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l7 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[2]);
        l5 = Interleave.unshuffle(lArray[3]);
        long l8 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l9 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[4]);
        l5 = Interleave.unshuffle(lArray[5]);
        long l10 = l4 & 0xFFFFFFFFL | l5 << 32;
        long l11 = l4 >>> 32 | l5 & 0xFFFFFFFF00000000L;
        l4 = Interleave.unshuffle(lArray[6]);
        long l12 = l4 & 0xFFFFFFFFL;
        long l13 = l4 >>> 32;
        lArray2[0] = l6 ^ l7 << 44;
        lArray2[1] = l8 ^ l9 << 44 ^ l7 >>> 20;
        lArray2[2] = l10 ^ l11 << 44 ^ l9 >>> 20;
        lArray2[3] = l12 ^ l13 << 44 ^ l11 >>> 20 ^ l7 << 13;
        lArray2[4] = l13 >>> 20 ^ l9 << 13 ^ l7 >>> 51;
        lArray2[5] = l11 << 13 ^ l9 >>> 51;
        lArray2[6] = l13 << 13 ^ l11 >>> 51;
    }

    public static void square(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.reduce(lArray3, lArray2);
    }

    public static void squareAddToExt(long[] lArray, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.addExt(lArray2, lArray3, lArray2);
    }

    public static void squareN(long[] lArray, int n4, long[] lArray2) {
        long[] lArray3 = Nat.create64(13);
        SecT409Field.implSquare(lArray, lArray3);
        SecT409Field.reduce(lArray3, lArray2);
        while (--n4 > 0) {
            SecT409Field.implSquare(lArray2, lArray3);
            SecT409Field.reduce(lArray3, lArray2);
        }
    }

    public static int trace(long[] lArray) {
        return (int)lArray[0] & 1;
    }

    protected static void implCompactExt(long[] lArray) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        long l11 = lArray[7];
        long l12 = lArray[8];
        long l13 = lArray[9];
        long l14 = lArray[10];
        long l15 = lArray[11];
        long l16 = lArray[12];
        long l17 = lArray[13];
        lArray[0] = l4 ^ l5 << 59;
        lArray[1] = l5 >>> 5 ^ l6 << 54;
        lArray[2] = l6 >>> 10 ^ l7 << 49;
        lArray[3] = l7 >>> 15 ^ l8 << 44;
        lArray[4] = l8 >>> 20 ^ l9 << 39;
        lArray[5] = l9 >>> 25 ^ l10 << 34;
        lArray[6] = l10 >>> 30 ^ l11 << 29;
        lArray[7] = l11 >>> 35 ^ l12 << 24;
        lArray[8] = l12 >>> 40 ^ l13 << 19;
        lArray[9] = l13 >>> 45 ^ l14 << 14;
        lArray[10] = l14 >>> 50 ^ l15 << 9;
        lArray[11] = l15 >>> 55 ^ l16 << 4 ^ l17 << 63;
        lArray[12] = l16 >>> 60 ^ l17 >>> 1;
        lArray[13] = 0L;
    }

    protected static void implExpand(long[] lArray, long[] lArray2) {
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        long l7 = lArray[3];
        long l8 = lArray[4];
        long l9 = lArray[5];
        long l10 = lArray[6];
        lArray2[0] = l4 & 0x7FFFFFFFFFFFFFFL;
        lArray2[1] = (l4 >>> 59 ^ l5 << 5) & 0x7FFFFFFFFFFFFFFL;
        lArray2[2] = (l5 >>> 54 ^ l6 << 10) & 0x7FFFFFFFFFFFFFFL;
        lArray2[3] = (l6 >>> 49 ^ l7 << 15) & 0x7FFFFFFFFFFFFFFL;
        lArray2[4] = (l7 >>> 44 ^ l8 << 20) & 0x7FFFFFFFFFFFFFFL;
        lArray2[5] = (l8 >>> 39 ^ l9 << 25) & 0x7FFFFFFFFFFFFFFL;
        lArray2[6] = l9 >>> 34 ^ l10 << 30;
    }

    protected static void implMultiply(long[] lArray, long[] lArray2, long[] lArray3) {
        long[] lArray4 = new long[7];
        long[] lArray5 = new long[7];
        SecT409Field.implExpand(lArray, lArray4);
        SecT409Field.implExpand(lArray2, lArray5);
        for (int i4 = 0; i4 < 7; ++i4) {
            SecT409Field.implMulwAcc(lArray4, lArray5[i4], lArray3, i4);
        }
        SecT409Field.implCompactExt(lArray3);
    }

    protected static void implMulwAcc(long[] lArray, long l4, long[] lArray2, int n4) {
        long[] lArray3 = new long[8];
        lArray3[1] = l4;
        lArray3[2] = lArray3[1] << 1;
        lArray3[3] = lArray3[2] ^ l4;
        lArray3[4] = lArray3[2] << 1;
        lArray3[5] = lArray3[4] ^ l4;
        lArray3[6] = lArray3[3] << 1;
        lArray3[7] = lArray3[6] ^ l4;
        for (int i4 = 0; i4 < 7; ++i4) {
            long l5 = lArray[i4];
            int n5 = (int)l5;
            long l6 = 0L;
            long l7 = lArray3[n5 & 7] ^ lArray3[n5 >>> 3 & 7] << 3;
            int n6 = 54;
            do {
                n5 = (int)(l5 >>> n6);
                long l8 = lArray3[n5 & 7] ^ lArray3[n5 >>> 3 & 7] << 3;
                l7 ^= l8 << n6;
                l6 ^= l8 >>> -n6;
            } while ((n6 -= 6) > 0);
            int n7 = n4 + i4;
            lArray2[n7] = lArray2[n7] ^ l7 & 0x7FFFFFFFFFFFFFFL;
            int n8 = n4 + i4 + 1;
            lArray2[n8] = lArray2[n8] ^ (l7 >>> 59 ^ l6 << 5);
        }
    }

    protected static void implSquare(long[] lArray, long[] lArray2) {
        for (int i4 = 0; i4 < 6; ++i4) {
            Interleave.expand64To128(lArray[i4], lArray2, i4 << 1);
        }
        lArray2[12] = Interleave.expand32to64((int)lArray[6]);
    }
}

