/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.gmss.util;

import org.bouncycastle.crypto.Digest;

public class GMSSRandom {
    private Digest messDigestTree;

    public GMSSRandom(Digest digest) {
        this.messDigestTree = digest;
    }

    public byte[] nextSeed(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        this.messDigestTree.update(byArray, 0, byArray.length);
        byArray2 = new byte[this.messDigestTree.getDigestSize()];
        this.messDigestTree.doFinal(byArray2, 0);
        this.addByteArrays(byArray, byArray2);
        this.addOne(byArray);
        return byArray2;
    }

    private void addByteArrays(byte[] byArray, byte[] byArray2) {
        int n4 = 0;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            int n5 = (0xFF & byArray[i4]) + (0xFF & byArray2[i4]) + n4;
            byArray[i4] = (byte)n5;
            n4 = (byte)(n5 >> 8);
        }
    }

    private void addOne(byte[] byArray) {
        int n4 = 1;
        for (int i4 = 0; i4 < byArray.length; ++i4) {
            int n5 = (0xFF & byArray[i4]) + n4;
            byArray[i4] = (byte)n5;
            n4 = (byte)(n5 >> 8);
        }
    }
}

