/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mceliece;

import java.math.BigInteger;
import org.bouncycastle.pqc.math.linearalgebra.BigIntUtils;
import org.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import org.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

final class Conversions {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private Conversions() {
    }

    public static GF2Vector encode(int n4, int n5, byte[] byArray) {
        if (n4 < n5) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = IntegerFunctions.binomial(n4, n5);
        if (bigInteger.compareTo(bigInteger2) >= 0) {
            throw new IllegalArgumentException("Encoded number too large.");
        }
        GF2Vector gF2Vector = new GF2Vector(n4);
        int n6 = n4;
        int n7 = n5;
        for (int i4 = 0; i4 < n4; ++i4) {
            bigInteger2 = bigInteger2.multiply(BigInteger.valueOf(n6 - n7)).divide(BigInteger.valueOf(n6));
            --n6;
            if (bigInteger2.compareTo(bigInteger) > 0) continue;
            gF2Vector.setBit(i4);
            bigInteger = bigInteger.subtract(bigInteger2);
            bigInteger2 = n6 == --n7 ? ONE : bigInteger2.multiply(BigInteger.valueOf(n7 + 1)).divide(BigInteger.valueOf(n6 - n7));
        }
        return gF2Vector;
    }

    public static byte[] decode(int n4, int n5, GF2Vector gF2Vector) {
        if (gF2Vector.getLength() != n4 || gF2Vector.getHammingWeight() != n5) {
            throw new IllegalArgumentException("vector has wrong length or hamming weight");
        }
        int[] nArray = gF2Vector.getVecArray();
        BigInteger bigInteger = IntegerFunctions.binomial(n4, n5);
        BigInteger bigInteger2 = ZERO;
        int n6 = n4;
        int n7 = n5;
        for (int i4 = 0; i4 < n4; ++i4) {
            bigInteger = bigInteger.multiply(BigInteger.valueOf(n6 - n7)).divide(BigInteger.valueOf(n6));
            --n6;
            int n8 = i4 >> 5;
            int n9 = nArray[n8] & 1 << (i4 & 0x1F);
            if (n9 == 0) continue;
            bigInteger2 = bigInteger2.add(bigInteger);
            bigInteger = n6 == --n7 ? ONE : bigInteger.multiply(BigInteger.valueOf(n7 + 1)).divide(BigInteger.valueOf(n6 - n7));
        }
        return BigIntUtils.toMinimalByteArray(bigInteger2);
    }

    public static byte[] signConversion(int n4, int n5, byte[] byArray) {
        int n6;
        int n7;
        byte[] byArray2;
        if (n4 < n5) {
            throw new IllegalArgumentException("n < t");
        }
        BigInteger bigInteger = IntegerFunctions.binomial(n4, n5);
        int n8 = bigInteger.bitLength() - 1;
        int n9 = n8 >> 3;
        int n10 = n8 & 7;
        if (n10 == 0) {
            --n9;
            n10 = 8;
        }
        int n11 = n4 >> 3;
        int n12 = n4 & 7;
        if (n12 == 0) {
            --n11;
            n12 = 8;
        }
        if (byArray.length < (byArray2 = new byte[n11 + 1]).length) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            for (n7 = byArray.length; n7 < byArray2.length; ++n7) {
                byArray2[n7] = 0;
            }
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, n11);
            n7 = (1 << n12) - 1;
            byArray2[n11] = (byte)(n7 & byArray[n11]);
        }
        BigInteger bigInteger2 = ZERO;
        int n13 = n4;
        int n14 = n5;
        for (int i4 = 0; i4 < n4; ++i4) {
            bigInteger = bigInteger.multiply(new BigInteger(Integer.toString(n13 - n14))).divide(new BigInteger(Integer.toString(n13)));
            --n13;
            int n15 = i4 >>> 3;
            n6 = i4 & 7;
            byte by = (byte)((n6 = 1 << n6) & byArray2[n15]);
            if (by == 0) continue;
            bigInteger2 = bigInteger2.add(bigInteger);
            bigInteger = n13 == --n14 ? ONE : bigInteger.multiply(new BigInteger(Integer.toString(n14 + 1))).divide(new BigInteger(Integer.toString(n13 - n14)));
        }
        byte[] byArray3 = new byte[n9 + 1];
        byte[] byArray4 = bigInteger2.toByteArray();
        if (byArray4.length < byArray3.length) {
            System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
            for (n6 = byArray4.length; n6 < byArray3.length; ++n6) {
                byArray3[n6] = 0;
            }
        } else {
            System.arraycopy(byArray4, 0, byArray3, 0, n9);
            byArray3[n9] = (byte)((1 << n10) - 1 & byArray4[n9]);
        }
        return byArray3;
    }
}

