/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.newhope;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.newhope.ChaCha20;
import org.bouncycastle.pqc.crypto.newhope.NTT;
import org.bouncycastle.pqc.crypto.newhope.Precomp;
import org.bouncycastle.pqc.crypto.newhope.Reduce;
import org.bouncycastle.util.Pack;

class Poly {
    Poly() {
    }

    static void add(short[] sArray, short[] sArray2, short[] sArray3) {
        for (int i4 = 0; i4 < 1024; ++i4) {
            sArray3[i4] = Reduce.barrett((short)(sArray[i4] + sArray2[i4]));
        }
    }

    static void fromBytes(short[] sArray, byte[] byArray) {
        for (int i4 = 0; i4 < 256; ++i4) {
            int n4 = 7 * i4;
            int n5 = byArray[n4 + 0] & 0xFF;
            int n6 = byArray[n4 + 1] & 0xFF;
            int n7 = byArray[n4 + 2] & 0xFF;
            int n8 = byArray[n4 + 3] & 0xFF;
            int n9 = byArray[n4 + 4] & 0xFF;
            int n10 = byArray[n4 + 5] & 0xFF;
            int n11 = byArray[n4 + 6] & 0xFF;
            int n12 = 4 * i4;
            sArray[n12 + 0] = (short)(n5 | (n6 & 0x3F) << 8);
            sArray[n12 + 1] = (short)(n6 >>> 6 | n7 << 2 | (n8 & 0xF) << 10);
            sArray[n12 + 2] = (short)(n8 >>> 4 | n9 << 4 | (n10 & 3) << 12);
            sArray[n12 + 3] = (short)(n10 >>> 2 | n11 << 6);
        }
    }

    static void fromNTT(short[] sArray) {
        NTT.bitReverse(sArray);
        NTT.core(sArray, Precomp.OMEGAS_INV_MONTGOMERY);
        NTT.mulCoefficients(sArray, Precomp.PSIS_INV_MONTGOMERY);
    }

    static void getNoise(short[] sArray, byte[] byArray, byte by) {
        byte[] byArray2 = new byte[8];
        byArray2[0] = by;
        byte[] byArray3 = new byte[4096];
        ChaCha20.process(byArray, byArray2, byArray3, 0, byArray3.length);
        for (int i4 = 0; i4 < 1024; ++i4) {
            int n4;
            int n5 = Pack.bigEndianToInt(byArray3, i4 * 4);
            int n6 = 0;
            for (n4 = 0; n4 < 8; ++n4) {
                n6 += n5 >> n4 & 0x1010101;
            }
            n4 = (n6 >>> 24) + (n6 >>> 0) & 0xFF;
            int n7 = (n6 >>> 16) + (n6 >>> 8) & 0xFF;
            sArray[i4] = (short)(n4 + 12289 - n7);
        }
    }

    static void pointWise(short[] sArray, short[] sArray2, short[] sArray3) {
        for (int i4 = 0; i4 < 1024; ++i4) {
            int n4 = sArray[i4] & 0xFFFF;
            int n5 = sArray2[i4] & 0xFFFF;
            short s4 = Reduce.montgomery(3186 * n5);
            sArray3[i4] = Reduce.montgomery(n4 * (s4 & 0xFFFF));
        }
    }

    static void toBytes(byte[] byArray, short[] sArray) {
        for (int i4 = 0; i4 < 256; ++i4) {
            int n4 = 4 * i4;
            short s4 = Poly.normalize(sArray[n4 + 0]);
            short s5 = Poly.normalize(sArray[n4 + 1]);
            short s6 = Poly.normalize(sArray[n4 + 2]);
            short s7 = Poly.normalize(sArray[n4 + 3]);
            int n5 = 7 * i4;
            byArray[n5 + 0] = (byte)s4;
            byArray[n5 + 1] = (byte)(s4 >> 8 | s5 << 6);
            byArray[n5 + 2] = (byte)(s5 >> 2);
            byArray[n5 + 3] = (byte)(s5 >> 10 | s6 << 4);
            byArray[n5 + 4] = (byte)(s6 >> 4);
            byArray[n5 + 5] = (byte)(s6 >> 12 | s7 << 2);
            byArray[n5 + 6] = (byte)(s7 >> 6);
        }
    }

    static void toNTT(short[] sArray) {
        NTT.mulCoefficients(sArray, Precomp.PSIS_BITREV_MONTGOMERY);
        NTT.core(sArray, Precomp.OMEGAS_MONTGOMERY);
    }

    static void uniform(short[] sArray, byte[] byArray) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(128);
        sHAKEDigest.update(byArray, 0, byArray.length);
        int n4 = 0;
        block0: while (true) {
            byte[] byArray2 = new byte[256];
            sHAKEDigest.doOutput(byArray2, 0, byArray2.length);
            int n5 = 0;
            while (true) {
                if (n5 >= byArray2.length) continue block0;
                int n6 = byArray2[n5] & 0xFF | (byArray2[n5 + 1] & 0xFF) << 8;
                if ((n6 &= 0x3FFF) < 12289) {
                    sArray[n4++] = (short)n6;
                    if (n4 == 1024) {
                        return;
                    }
                }
                n5 += 2;
            }
            break;
        }
    }

    private static short normalize(short s4) {
        int n4 = Reduce.barrett(s4);
        int n5 = n4 - 12289;
        int n6 = n5 >> 31;
        n4 = n5 ^ (n4 ^ n5) & n6;
        return (short)n4;
    }
}

