/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.spec;

import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialRingGF2;

public class McElieceCCA2KeyGenParameterSpec
implements AlgorithmParameterSpec {
    public static final String SHA1 = "SHA-1";
    public static final String SHA224 = "SHA-224";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public static final int DEFAULT_M = 11;
    public static final int DEFAULT_T = 50;
    private final int m;
    private final int t;
    private final int n;
    private int fieldPoly;
    private final String digest;

    public McElieceCCA2KeyGenParameterSpec() {
        this(11, 50, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n4) {
        this(n4, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n4, String string) {
        if (n4 < 1) {
            throw new IllegalArgumentException("key size must be positive");
        }
        int n5 = 0;
        int n6 = 1;
        while (n6 < n4) {
            n6 <<= 1;
            ++n5;
        }
        this.t = (n6 >>> 1) / n5;
        this.m = n5;
        this.n = n6;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n5);
        this.digest = string;
    }

    public McElieceCCA2KeyGenParameterSpec(int n4, int n5) {
        this(n4, n5, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n4, int n5, String string) {
        if (n4 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (n4 > 32) {
            throw new IllegalArgumentException("m is too large");
        }
        this.m = n4;
        this.n = 1 << n4;
        if (n5 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (n5 > this.n) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        this.t = n5;
        this.fieldPoly = PolynomialRingGF2.getIrreduciblePolynomial(n4);
        this.digest = string;
    }

    public McElieceCCA2KeyGenParameterSpec(int n4, int n5, int n6) {
        this(n4, n5, n6, SHA256);
    }

    public McElieceCCA2KeyGenParameterSpec(int n4, int n5, int n6, String string) {
        this.m = n4;
        if (n4 < 1) {
            throw new IllegalArgumentException("m must be positive");
        }
        if (n4 > 32) {
            throw new IllegalArgumentException(" m is too large");
        }
        this.n = 1 << n4;
        this.t = n5;
        if (n5 < 0) {
            throw new IllegalArgumentException("t must be positive");
        }
        if (n5 > this.n) {
            throw new IllegalArgumentException("t must be less than n = 2^m");
        }
        if (PolynomialRingGF2.degree(n6) != n4 || !PolynomialRingGF2.isIrreducible(n6)) {
            throw new IllegalArgumentException("polynomial is not a field polynomial for GF(2^m)");
        }
        this.fieldPoly = n6;
        this.digest = string;
    }

    public int getM() {
        return this.m;
    }

    public int getN() {
        return this.n;
    }

    public int getT() {
        return this.t;
    }

    public int getFieldPoly() {
        return this.fieldPoly;
    }

    public String getDigest() {
        return this.digest;
    }
}

