/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import java.security.SecureRandom;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.GF2mVector;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.LittleEndianConversions;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.RandUtils;
import org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2Vector
extends Vector {
    private int[] v;

    public GF2Vector(int n4) {
        if (n4 < 0) {
            throw new ArithmeticException("Negative length.");
        }
        this.length = n4;
        this.v = new int[n4 + 31 >> 5];
    }

    public GF2Vector(int n4, SecureRandom secureRandom) {
        int n5;
        this.length = n4;
        int n6 = n4 + 31 >> 5;
        this.v = new int[n6];
        for (n5 = n6 - 1; n5 >= 0; --n5) {
            this.v[n5] = secureRandom.nextInt();
        }
        n5 = n4 & 0x1F;
        if (n5 != 0) {
            int n7 = n6 - 1;
            this.v[n7] = this.v[n7] & (1 << n5) - 1;
        }
    }

    public GF2Vector(int n4, int n5, SecureRandom secureRandom) {
        int n6;
        if (n5 > n4) {
            throw new ArithmeticException("The hamming weight is greater than the length of vector.");
        }
        this.length = n4;
        int n7 = n4 + 31 >> 5;
        this.v = new int[n7];
        int[] nArray = new int[n4];
        for (n6 = 0; n6 < n4; ++n6) {
            nArray[n6] = n6;
        }
        n6 = n4;
        for (int i4 = 0; i4 < n5; ++i4) {
            int n8 = RandUtils.nextInt(secureRandom, n6);
            this.setBit(nArray[n8]);
            nArray[n8] = nArray[--n6];
        }
    }

    public GF2Vector(int n4, int[] nArray) {
        if (n4 < 0) {
            throw new ArithmeticException("negative length");
        }
        this.length = n4;
        int n5 = n4 + 31 >> 5;
        if (nArray.length != n5) {
            throw new ArithmeticException("length mismatch");
        }
        this.v = IntUtils.clone(nArray);
        int n6 = n4 & 0x1F;
        if (n6 != 0) {
            int n7 = n5 - 1;
            this.v[n7] = this.v[n7] & (1 << n6) - 1;
        }
    }

    public GF2Vector(GF2Vector gF2Vector) {
        this.length = gF2Vector.length;
        this.v = IntUtils.clone(gF2Vector.v);
    }

    protected GF2Vector(int[] nArray, int n4) {
        this.v = nArray;
        this.length = n4;
    }

    public static GF2Vector OS2VP(int n4, byte[] byArray) {
        if (n4 < 0) {
            throw new ArithmeticException("negative length");
        }
        int n5 = n4 + 7 >> 3;
        if (byArray.length > n5) {
            throw new ArithmeticException("length mismatch");
        }
        return new GF2Vector(n4, LittleEndianConversions.toIntArray(byArray));
    }

    public byte[] getEncoded() {
        int n4 = this.length + 7 >> 3;
        return LittleEndianConversions.toByteArray(this.v, n4);
    }

    public int[] getVecArray() {
        return this.v;
    }

    public int getHammingWeight() {
        int n4 = 0;
        for (int i4 = 0; i4 < this.v.length; ++i4) {
            int n5 = this.v[i4];
            for (int i5 = 0; i5 < 32; ++i5) {
                int n6 = n5 & 1;
                if (n6 != 0) {
                    ++n4;
                }
                n5 >>>= 1;
            }
        }
        return n4;
    }

    public boolean isZero() {
        for (int i4 = this.v.length - 1; i4 >= 0; --i4) {
            if (this.v[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public int getBit(int n4) {
        if (n4 >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = n4 >> 5;
        int n6 = n4 & 0x1F;
        return (this.v[n5] & 1 << n6) >>> n6;
    }

    public void setBit(int n4) {
        if (n4 >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = n4 >> 5;
        this.v[n5] = this.v[n5] | 1 << (n4 & 0x1F);
    }

    public Vector add(Vector vector) {
        if (!(vector instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        GF2Vector gF2Vector = (GF2Vector)vector;
        if (this.length != gF2Vector.length) {
            throw new ArithmeticException("length mismatch");
        }
        int[] nArray = IntUtils.clone(((GF2Vector)vector).v);
        for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
            int n4 = i4;
            nArray[n4] = nArray[n4] ^ this.v[i4];
        }
        return new GF2Vector(this.length, nArray);
    }

    public Vector multiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (this.length != nArray.length) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Vector gF2Vector = new GF2Vector(this.length);
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            int n4 = this.v[nArray[i4] >> 5] & 1 << (nArray[i4] & 0x1F);
            if (n4 == 0) continue;
            int n5 = i4 >> 5;
            gF2Vector.v[n5] = gF2Vector.v[n5] | 1 << (i4 & 0x1F);
        }
        return gF2Vector;
    }

    public GF2Vector extractVector(int[] nArray) {
        int n4 = nArray.length;
        if (nArray[n4 - 1] > this.length) {
            throw new ArithmeticException("invalid index set");
        }
        GF2Vector gF2Vector = new GF2Vector(n4);
        for (int i4 = 0; i4 < n4; ++i4) {
            int n5 = this.v[nArray[i4] >> 5] & 1 << (nArray[i4] & 0x1F);
            if (n5 == 0) continue;
            int n6 = i4 >> 5;
            gF2Vector.v[n6] = gF2Vector.v[n6] | 1 << (i4 & 0x1F);
        }
        return gF2Vector;
    }

    public GF2Vector extractLeftVector(int n4) {
        if (n4 > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (n4 == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector gF2Vector = new GF2Vector(n4);
        int n5 = n4 >> 5;
        int n6 = n4 & 0x1F;
        System.arraycopy(this.v, 0, gF2Vector.v, 0, n5);
        if (n6 != 0) {
            gF2Vector.v[n5] = this.v[n5] & (1 << n6) - 1;
        }
        return gF2Vector;
    }

    public GF2Vector extractRightVector(int n4) {
        if (n4 > this.length) {
            throw new ArithmeticException("invalid length");
        }
        if (n4 == this.length) {
            return new GF2Vector(this);
        }
        GF2Vector gF2Vector = new GF2Vector(n4);
        int n5 = this.length - n4 >> 5;
        int n6 = this.length - n4 & 0x1F;
        int n7 = n4 + 31 >> 5;
        int n8 = n5;
        if (n6 != 0) {
            for (int i4 = 0; i4 < n7 - 1; ++i4) {
                gF2Vector.v[i4] = this.v[n8++] >>> n6 | this.v[n8] << 32 - n6;
            }
            gF2Vector.v[n7 - 1] = this.v[n8++] >>> n6;
            if (n8 < this.v.length) {
                int n9 = n7 - 1;
                gF2Vector.v[n9] = gF2Vector.v[n9] | this.v[n8] << 32 - n6;
            }
        } else {
            System.arraycopy(this.v, n5, gF2Vector.v, 0, n7);
        }
        return gF2Vector;
    }

    public GF2mVector toExtensionFieldVector(GF2mField gF2mField) {
        int n4 = gF2mField.getDegree();
        if (this.length % n4 != 0) {
            throw new ArithmeticException("conversion is impossible");
        }
        int n5 = this.length / n4;
        int[] nArray = new int[n5];
        int n6 = 0;
        for (int i4 = n5 - 1; i4 >= 0; --i4) {
            for (int i5 = gF2mField.getDegree() - 1; i5 >= 0; --i5) {
                int n7 = n6 >>> 5;
                int n8 = n6 & 0x1F;
                int n9 = this.v[n7] >>> n8 & 1;
                if (n9 == 1) {
                    int n10 = i4;
                    nArray[n10] = nArray[n10] ^ 1 << i5;
                }
                ++n6;
            }
        }
        return new GF2mVector(gF2mField, nArray);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2Vector)) {
            return false;
        }
        GF2Vector gF2Vector = (GF2Vector)object;
        return this.length == gF2Vector.length && IntUtils.equals(this.v, gF2Vector.v);
    }

    public int hashCode() {
        int n4 = this.length;
        n4 = n4 * 31 + this.v.hashCode();
        return n4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i4 = 0; i4 < this.length; ++i4) {
            int n4;
            int n5;
            int n6;
            if (i4 != 0 && (i4 & 0x1F) == 0) {
                stringBuffer.append(' ');
            }
            if ((n6 = this.v[n5 = i4 >> 5] & 1 << (n4 = i4 & 0x1F)) == 0) {
                stringBuffer.append('0');
                continue;
            }
            stringBuffer.append('1');
        }
        return stringBuffer.toString();
    }
}

