/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.linearalgebra;

import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle.pqc.math.linearalgebra.Permutation;
import org.bouncycastle.pqc.math.linearalgebra.Vector;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField gF2mField, byte[] byArray) {
        int n4;
        this.field = new GF2mField(gF2mField);
        int n5 = 1;
        for (n4 = 8; gF2mField.getDegree() > n4; n4 += 8) {
            ++n5;
        }
        if (byArray.length % n5 != 0) {
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
        this.length = byArray.length / n5;
        this.vector = new int[this.length];
        n5 = 0;
        for (int i4 = 0; i4 < this.vector.length; ++i4) {
            for (int i5 = 0; i5 < n4; i5 += 8) {
                int n6 = i4;
                this.vector[n6] = this.vector[n6] | (byArray[n5++] & 0xFF) << i5;
            }
            if (gF2mField.isElementOfThisField(this.vector[i4])) continue;
            throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
        }
    }

    public GF2mVector(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.length = nArray.length;
        for (int i4 = nArray.length - 1; i4 >= 0; --i4) {
            if (gF2mField.isElementOfThisField(nArray[i4])) continue;
            throw new ArithmeticException("Element array is not specified over the given finite field.");
        }
        this.vector = IntUtils.clone(nArray);
    }

    public GF2mVector(GF2mVector gF2mVector) {
        this.field = new GF2mField(gF2mVector.field);
        this.length = gF2mVector.length;
        this.vector = IntUtils.clone(gF2mVector.vector);
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    public byte[] getEncoded() {
        int n4;
        int n5 = 1;
        for (n4 = 8; this.field.getDegree() > n4; n4 += 8) {
            ++n5;
        }
        byte[] byArray = new byte[this.vector.length * n5];
        n5 = 0;
        for (int i4 = 0; i4 < this.vector.length; ++i4) {
            for (int i5 = 0; i5 < n4; i5 += 8) {
                byArray[n5++] = (byte)(this.vector[i4] >>> i5);
            }
        }
        return byArray;
    }

    public boolean isZero() {
        for (int i4 = this.vector.length - 1; i4 >= 0; --i4) {
            if (this.vector[i4] == 0) continue;
            return false;
        }
        return true;
    }

    public Vector add(Vector vector) {
        throw new RuntimeException("not implemented");
    }

    public Vector multiply(Permutation permutation) {
        int[] nArray = permutation.getVector();
        if (this.length != nArray.length) {
            throw new ArithmeticException("permutation size and vector size mismatch");
        }
        int[] nArray2 = new int[this.length];
        for (int i4 = 0; i4 < nArray.length; ++i4) {
            nArray2[i4] = this.vector[nArray[i4]];
        }
        return new GF2mVector(this.field, nArray2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GF2mVector)) {
            return false;
        }
        GF2mVector gF2mVector = (GF2mVector)object;
        if (!this.field.equals(gF2mVector.field)) {
            return false;
        }
        return IntUtils.equals(this.vector, gF2mVector.vector);
    }

    public int hashCode() {
        int n4 = this.field.hashCode();
        n4 = n4 * 31 + this.vector.hashCode();
        return n4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i4 = 0; i4 < this.vector.length; ++i4) {
            for (int i5 = 0; i5 < this.field.getDegree(); ++i5) {
                int n4 = i5 & 0x1F;
                int n5 = 1 << n4;
                int n6 = this.vector[i4] & n5;
                if (n6 != 0) {
                    stringBuffer.append('1');
                    continue;
                }
                stringBuffer.append('0');
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

