/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

public class IPAddress {
    public static boolean isValid(String string) {
        return IPAddress.isValidIPv4(string) || IPAddress.isValidIPv6(string);
    }

    public static boolean isValidWithNetMask(String string) {
        return IPAddress.isValidIPv4WithNetmask(string) || IPAddress.isValidIPv6WithNetmask(string);
    }

    public static boolean isValidIPv4(String string) {
        int n4;
        if (string.length() == 0) {
            return false;
        }
        int n5 = 0;
        String string2 = string + ".";
        int n6 = 0;
        while (n6 < string2.length() && (n4 = string2.indexOf(46, n6)) > n6) {
            int n7;
            if (n5 == 4) {
                return false;
            }
            try {
                n7 = Integer.parseInt(string2.substring(n6, n4));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n7 < 0 || n7 > 255) {
                return false;
            }
            n6 = n4 + 1;
            ++n5;
        }
        return n5 == 4;
    }

    public static boolean isValidIPv4WithNetmask(String string) {
        int n4 = string.indexOf("/");
        String string2 = string.substring(n4 + 1);
        return n4 > 0 && IPAddress.isValidIPv4(string.substring(0, n4)) && (IPAddress.isValidIPv4(string2) || IPAddress.isMaskValue(string2, 32));
    }

    public static boolean isValidIPv6WithNetmask(String string) {
        int n4 = string.indexOf("/");
        String string2 = string.substring(n4 + 1);
        return n4 > 0 && IPAddress.isValidIPv6(string.substring(0, n4)) && (IPAddress.isValidIPv6(string2) || IPAddress.isMaskValue(string2, 128));
    }

    private static boolean isMaskValue(String string, int n4) {
        try {
            int n5 = Integer.parseInt(string);
            return n5 >= 0 && n5 <= n4;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidIPv6(String string) {
        int n4;
        if (string.length() == 0) {
            return false;
        }
        int n5 = 0;
        String string2 = string + ":";
        boolean bl = false;
        int n6 = 0;
        while (n6 < string2.length() && (n4 = string2.indexOf(58, n6)) >= n6) {
            if (n5 == 8) {
                return false;
            }
            if (n6 != n4) {
                String string3 = string2.substring(n6, n4);
                if (n4 == string2.length() - 1 && string3.indexOf(46) > 0) {
                    if (!IPAddress.isValidIPv4(string3)) {
                        return false;
                    }
                    ++n5;
                } else {
                    int n7;
                    try {
                        n7 = Integer.parseInt(string2.substring(n6, n4), 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return false;
                    }
                    if (n7 < 0 || n7 > 65535) {
                        return false;
                    }
                }
            } else {
                if (n4 != 1 && n4 != string2.length() - 1 && bl) {
                    return false;
                }
                bl = true;
            }
            n6 = n4 + 1;
            ++n5;
        }
        return n5 == 8 || bl;
    }
}

