/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Vector;
import org.bouncycastle.util.StringList;

public final class Strings {
    private static String LINE_SEPARATOR;

    public static String fromUTF8ByteArray(byte[] byArray) {
        int n4 = 0;
        int n5 = 0;
        while (n4 < byArray.length) {
            ++n5;
            if ((byArray[n4] & 0xF0) == 240) {
                ++n5;
                n4 += 4;
                continue;
            }
            if ((byArray[n4] & 0xE0) == 224) {
                n4 += 3;
                continue;
            }
            if ((byArray[n4] & 0xC0) == 192) {
                n4 += 2;
                continue;
            }
            ++n4;
        }
        char[] cArray = new char[n5];
        n4 = 0;
        n5 = 0;
        while (n4 < byArray.length) {
            char c5;
            if ((byArray[n4] & 0xF0) == 240) {
                int n6 = (byArray[n4] & 3) << 18 | (byArray[n4 + 1] & 0x3F) << 12 | (byArray[n4 + 2] & 0x3F) << 6 | byArray[n4 + 3] & 0x3F;
                int n7 = n6 - 65536;
                char c6 = (char)(0xD800 | n7 >> 10);
                char c7 = (char)(0xDC00 | n7 & 0x3FF);
                cArray[n5++] = c6;
                c5 = c7;
                n4 += 4;
            } else if ((byArray[n4] & 0xE0) == 224) {
                c5 = (char)((byArray[n4] & 0xF) << 12 | (byArray[n4 + 1] & 0x3F) << 6 | byArray[n4 + 2] & 0x3F);
                n4 += 3;
            } else if ((byArray[n4] & 0xD0) == 208) {
                c5 = (char)((byArray[n4] & 0x1F) << 6 | byArray[n4 + 1] & 0x3F);
                n4 += 2;
            } else if ((byArray[n4] & 0xC0) == 192) {
                c5 = (char)((byArray[n4] & 0x1F) << 6 | byArray[n4 + 1] & 0x3F);
                n4 += 2;
            } else {
                c5 = (char)(byArray[n4] & 0xFF);
                ++n4;
            }
            cArray[n5++] = c5;
        }
        return new String(cArray);
    }

    public static byte[] toUTF8ByteArray(String string) {
        return Strings.toUTF8ByteArray(string.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] cArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(cArray, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void toUTF8ByteArray(char[] cArray, OutputStream outputStream) throws IOException {
        char[] cArray2 = cArray;
        for (int i4 = 0; i4 < cArray2.length; ++i4) {
            char c5 = cArray2[i4];
            if (c5 < '\u0080') {
                outputStream.write(c5);
                continue;
            }
            if (c5 < '\u0800') {
                outputStream.write(0xC0 | c5 >> 6);
                outputStream.write(0x80 | c5 & 0x3F);
                continue;
            }
            if (c5 >= '\ud800' && c5 <= '\udfff') {
                if (i4 + 1 >= cArray2.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char c6 = c5;
                char c7 = c5 = cArray2[++i4];
                if (c6 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int n4 = ((c6 & 0x3FF) << 10 | c7 & 0x3FF) + 65536;
                outputStream.write(0xF0 | n4 >> 18);
                outputStream.write(0x80 | n4 >> 12 & 0x3F);
                outputStream.write(0x80 | n4 >> 6 & 0x3F);
                outputStream.write(0x80 | n4 & 0x3F);
                continue;
            }
            outputStream.write(0xE0 | c5 >> 12);
            outputStream.write(0x80 | c5 >> 6 & 0x3F);
            outputStream.write(0x80 | c5 & 0x3F);
        }
    }

    public static String toUpperCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i4 = 0; i4 != cArray.length; ++i4) {
            char c5 = cArray[i4];
            if ('a' > c5 || 'z' < c5) continue;
            bl = true;
            cArray[i4] = (char)(c5 - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i4 = 0; i4 != cArray.length; ++i4) {
            char c5 = cArray[i4];
            if ('A' > c5 || 'Z' < c5) continue;
            bl = true;
            cArray[i4] = (char)(c5 - 65 + 97);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static byte[] toByteArray(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            byArray[i4] = (byte)cArray[i4];
        }
        return byArray;
    }

    public static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i4 = 0; i4 != byArray.length; ++i4) {
            char c5 = string.charAt(i4);
            byArray[i4] = (byte)c5;
        }
        return byArray;
    }

    public static int toByteArray(String string, byte[] byArray, int n4) {
        int n5 = string.length();
        for (int i4 = 0; i4 < n5; ++i4) {
            char c5 = string.charAt(i4);
            byArray[n4 + i4] = (byte)c5;
        }
        return n5;
    }

    public static String fromByteArray(byte[] byArray) {
        return new String(Strings.asCharArray(byArray));
    }

    public static char[] asCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i4 = 0; i4 != cArray.length; ++i4) {
            cArray[i4] = (char)(byArray[i4] & 0xFF);
        }
        return cArray;
    }

    public static String[] split(String string, char c5) {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        while (bl) {
            int n4 = string.indexOf(c5);
            if (n4 > 0) {
                String string2 = string.substring(0, n4);
                vector.addElement(string2);
                string = string.substring(n4 + 1);
                continue;
            }
            bl = false;
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int i4 = 0; i4 != stringArray.length; ++i4) {
            stringArray[i4] = (String)vector.elementAt(i4);
        }
        return stringArray;
    }

    public static StringList newList() {
        return new StringListImpl();
    }

    public static String lineSeparator() {
        return LINE_SEPARATOR;
    }

    static {
        try {
            LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        catch (Exception exception) {
            try {
                LINE_SEPARATOR = String.format("%n", new Object[0]);
            }
            catch (Exception exception2) {
                LINE_SEPARATOR = "\n";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringListImpl
    extends ArrayList<String>
    implements StringList {
        private StringListImpl() {
        }

        @Override
        public boolean add(String string) {
            return super.add(string);
        }

        @Override
        public String set(int n4, String string) {
            return super.set(n4, string);
        }

        @Override
        public void add(int n4, String string) {
            super.add(n4, string);
        }

        @Override
        public String[] toStringArray() {
            String[] stringArray = new String[this.size()];
            for (int i4 = 0; i4 != stringArray.length; ++i4) {
                stringArray[i4] = (String)this.get(i4);
            }
            return stringArray;
        }

        @Override
        public String[] toStringArray(int n4, int n5) {
            String[] stringArray = new String[n5 - n4];
            for (int i4 = n4; i4 != this.size() && i4 != n5; ++i4) {
                stringArray[i4 - n4] = (String)this.get(i4);
            }
            return stringArray;
        }
    }
}

