/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter.qual;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.dataflow.qual.Pure;

public enum ConversionCategory {
    GENERAL(null, "bBhHsS"),
    CHAR(new Class[]{Character.class, Byte.class, Short.class, Integer.class}, "cC"),
    INT(new Class[]{Byte.class, Short.class, Integer.class, Long.class, BigInteger.class}, "doxX"),
    FLOAT(new Class[]{Float.class, Double.class, BigDecimal.class}, "eEfgGaA"),
    TIME(new Class[]{Long.class, Calendar.class, Date.class}, "tT"),
    CHAR_AND_INT(new Class[]{Byte.class, Short.class, Integer.class}, null),
    INT_AND_TIME(new Class[]{Long.class}, null),
    NULL(new Class[0], null),
    UNUSED(null, null);

    public final Class<?>[] types;
    public final String chars;

    private ConversionCategory(Class<?>[] types, String chars) {
        this.types = types;
        this.chars = chars;
    }

    public static ConversionCategory fromConversionChar(char c5) {
        for (ConversionCategory v4 : new ConversionCategory[]{GENERAL, CHAR, INT, FLOAT, TIME}) {
            if (!v4.chars.contains(String.valueOf(c5))) continue;
            return v4;
        }
        throw new IllegalArgumentException("Bad conversion character " + c5);
    }

    private static <E> Set<E> arrayToSet(E[] a5) {
        return new HashSet<E>(Arrays.asList(a5));
    }

    public static boolean isSubsetOf(ConversionCategory a5, ConversionCategory b5) {
        return ConversionCategory.intersect(a5, b5) == a5;
    }

    public static ConversionCategory intersect(ConversionCategory a5, ConversionCategory b5) {
        if (a5 == UNUSED) {
            return b5;
        }
        if (b5 == UNUSED) {
            return a5;
        }
        if (a5 == GENERAL) {
            return b5;
        }
        if (b5 == GENERAL) {
            return a5;
        }
        Set<Class<Class<?>>> as = ConversionCategory.arrayToSet(a5.types);
        Set<Class<?>> bs = ConversionCategory.arrayToSet(b5.types);
        as.retainAll(bs);
        for (ConversionCategory v4 : new ConversionCategory[]{CHAR, INT, FLOAT, TIME, CHAR_AND_INT, INT_AND_TIME, NULL}) {
            Set<Class<?>> vs = ConversionCategory.arrayToSet(v4.types);
            if (!vs.equals(as)) continue;
            return v4;
        }
        throw new RuntimeException();
    }

    public static ConversionCategory union(ConversionCategory a5, ConversionCategory b5) {
        if (a5 == UNUSED || b5 == UNUSED) {
            return UNUSED;
        }
        if (a5 == GENERAL || b5 == GENERAL) {
            return GENERAL;
        }
        if (a5 == CHAR_AND_INT && b5 == INT_AND_TIME || a5 == INT_AND_TIME && b5 == CHAR_AND_INT) {
            return INT;
        }
        Set<Class<?>> as = ConversionCategory.arrayToSet(a5.types);
        Set<Class<?>> bs = ConversionCategory.arrayToSet(b5.types);
        as.addAll(bs);
        for (ConversionCategory v4 : new ConversionCategory[]{NULL, CHAR_AND_INT, INT_AND_TIME, CHAR, INT, FLOAT, TIME}) {
            Set<Class<?>> vs = ConversionCategory.arrayToSet(v4.types);
            if (!vs.equals(as)) continue;
            return v4;
        }
        return GENERAL;
    }

    private String className(Class<?> cls) {
        if (cls == Boolean.class) {
            return "boolean";
        }
        if (cls == Character.class) {
            return "char";
        }
        if (cls == Byte.class) {
            return "byte";
        }
        if (cls == Short.class) {
            return "short";
        }
        if (cls == Integer.class) {
            return "int";
        }
        if (cls == Long.class) {
            return "long";
        }
        if (cls == Float.class) {
            return "float";
        }
        if (cls == Double.class) {
            return "double";
        }
        return cls.getSimpleName();
    }

    @Pure
    public String toString() {
        StringBuilder sb = new StringBuilder(this.name());
        sb.append(" conversion category (one of: ");
        boolean first = true;
        for (Class<?> cls : this.types) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(this.className(cls));
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }
}

