/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array) {
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer b5) {
        return b5.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer b5) {
        return b5.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b5) {
        return b5.get();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b5, int i4) {
        return b5.get(i4);
    }

    public static ByteBuffer getUnsigned(ByteBuffer b5, byte[] bs, int i4, int l4) {
        return b5.get(bs, i4, l4);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b5, @Unsigned byte ubyte) {
        return b5.put(ubyte);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b5, int i4, @Unsigned byte ubyte) {
        return b5.put(i4, ubyte);
    }

    public static IntBuffer putUnsigned(IntBuffer b5, @Unsigned int uint) {
        return b5.put(uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b5, int i4, @Unsigned int uint) {
        return b5.put(i4, uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b5, @Unsigned int[] uints) {
        return b5.put(uints);
    }

    public static IntBuffer putUnsigned(IntBuffer b5, @Unsigned int[] uints, int i4, int l4) {
        return b5.put(uints, i4, l4);
    }

    public static @Unsigned int getUnsigned(IntBuffer b5, int i4) {
        return b5.get(i4);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b5, @Unsigned short ushort) {
        return b5.putShort(ushort);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b5, int i4, @Unsigned short ushort) {
        return b5.putShort(i4, ushort);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b5, @Unsigned int uint) {
        return b5.putInt(uint);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b5, int i4, @Unsigned int uint) {
        return b5.putInt(i4, uint);
    }

    public static ByteBuffer putUnsignedLong(ByteBuffer b5, int i4, @Unsigned long ulong) {
        return b5.putLong(i4, ulong);
    }

    public static @Unsigned char readUnsignedChar(RandomAccessFile f5) throws IOException {
        return f5.readChar();
    }

    public static @Unsigned int readUnsignedInt(RandomAccessFile f5) throws IOException {
        return f5.readInt();
    }

    public static @Unsigned long readUnsignedLong(RandomAccessFile f5) throws IOException {
        return f5.readLong();
    }

    public static int readUnsigned(RandomAccessFile f5, @Unsigned byte[] b5, int off, int len) throws IOException {
        return f5.read(b5, off, len);
    }

    public static void readFullyUnsigned(RandomAccessFile f5, @Unsigned byte[] b5) throws IOException {
        f5.readFully(b5);
    }

    public static void writeUnsigned(RandomAccessFile f5, @Unsigned byte[] bs, int off, int len) throws IOException {
        f5.write(bs, off, len);
    }

    public static void writeUnsignedByte(RandomAccessFile f5, @Unsigned byte b5) throws IOException {
        f5.writeByte(Byte.toUnsignedInt(b5));
    }

    public static void writeUnsignedChar(RandomAccessFile f5, @Unsigned char c5) throws IOException {
        f5.writeChar(SignednessUtil.toUnsignedInt(c5));
    }

    public static void writeUnsignedShort(RandomAccessFile f5, @Unsigned short s4) throws IOException {
        f5.writeShort(Short.toUnsignedInt(s4));
    }

    public static void writeUnsignedInt(RandomAccessFile f5, @Unsigned int i4) throws IOException {
        f5.writeInt(i4);
    }

    public static void writeUnsignedLong(RandomAccessFile f5, @Unsigned long l4) throws IOException {
        f5.writeLong(l4);
    }

    public static void getUnsigned(ByteBuffer b5, @Unsigned byte[] bs) {
        b5.get(bs);
    }

    public static int compareUnsigned(@Unsigned short x4, @Unsigned short y4) {
        return Integer.compareUnsigned(Short.toUnsignedInt(x4), Short.toUnsignedInt(y4));
    }

    public static int compareUnsigned(@Unsigned byte x4, @Unsigned byte y4) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(x4), Byte.toUnsignedInt(y4));
    }

    public static String toUnsignedString(@Unsigned short s4) {
        return Long.toString(Short.toUnsignedLong(s4));
    }

    public static String toUnsignedString(@Unsigned short s4, int radix) {
        return Integer.toUnsignedString(Short.toUnsignedInt(s4), radix);
    }

    public static String toUnsignedString(@Unsigned byte b5) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b5));
    }

    public static String toUnsignedString(@Unsigned byte b5, int radix) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b5), radix);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l4) {
        if (l4 >= 0L) {
            return BigInteger.valueOf(l4);
        }
        int upper = (int)(l4 >>> 32);
        int lower = (int)l4;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte b5) {
        return (short)(b5 & 0xFF);
    }

    public static @Unsigned long toUnsignedLong(@Unsigned char c5) {
        return (long)c5 & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned char c5) {
        return c5 & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned char c5) {
        return (short)(c5 & 0xFF);
    }

    public static float toFloat(@Unsigned byte b5) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b5)).floatValue();
    }

    public static float toFloat(@Unsigned short s4) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s4)).floatValue();
    }

    public static float toFloat(@Unsigned int i4) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i4)).floatValue();
    }

    public static float toFloat(@Unsigned long l4) {
        return SignednessUtil.toUnsignedBigInteger(l4).floatValue();
    }

    public static double toDouble(@Unsigned byte b5) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b5)).doubleValue();
    }

    public static double toDouble(@Unsigned short s4) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s4)).doubleValue();
    }

    public static double toDouble(@Unsigned int i4) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i4)).doubleValue();
    }

    public static double toDouble(@Unsigned long l4) {
        return SignednessUtil.toUnsignedBigInteger(l4).doubleValue();
    }

    public static @Unsigned byte byteFromFloat(float f5) {
        assert (f5 >= 0.0f);
        return (byte)f5;
    }

    public static @Unsigned short shortFromFloat(float f5) {
        assert (f5 >= 0.0f);
        return (short)f5;
    }

    public static @Unsigned int intFromFloat(float f5) {
        assert (f5 >= 0.0f);
        return (int)f5;
    }

    public static @Unsigned long longFromFloat(float f5) {
        assert (f5 >= 0.0f);
        return (long)f5;
    }

    public static @Unsigned byte byteFromDouble(double d5) {
        assert (d5 >= 0.0);
        return (byte)d5;
    }

    public static @Unsigned short shortFromDouble(double d5) {
        assert (d5 >= 0.0);
        return (short)d5;
    }

    public static @Unsigned int intFromDouble(double d5) {
        assert (d5 >= 0.0);
        return (int)d5;
    }

    public static @Unsigned long longFromDouble(double d5) {
        assert (d5 >= 0.0);
        return (long)d5;
    }
}

